#!/bin/bash -xe

FORMULA_VERSION=${FORMULA_VERSION:-2018.3.1}
APT_MIRANTIS_SALT_REPO=${APT_MIRANTIS_SALT_REPO:-"http://apt.mirantis.com/xenial/ $FORMULA_VERSION salt"}
SALT_OPTS="-t 10 --retcode-passthrough --no-color"

salt-call ${SALT_OPTS} reclass.validate_pillar

echo "deb [arch=amd64] ${APT_MIRANTIS_SALT_REPO}" > /etc/apt/sources.list.d/mcp_salt.list
apt-get update
apt-get install salt-formula* -y

salt-call saltutil.refresh_pillar
salt-call saltutil.sync_all
salt-call ${SALT_OPTS} state.sls salt
salt-call ${SALT_OPTS} state.sls linux.system.repo,linux.system.package,linux.system.user,linux.system.directory,linux.system.config
salt-call ${SALT_OPTS} state.sls linux.network
salt-call ${SALT_OPTS} state.sls openssh
salt-call ${SALT_OPTS} state.sls git.server
salt-call ${SALT_OPTS} state.sls postgresql
# install only MAAS packages, don't configure anything.
# Configuration will be processed during cfg01 initialization.
# Those step, required to have clean MAAS configuration - w\o auto import and etc.
salt-call ${SALT_OPTS} state.sls_id maas_cluster_packages maas
salt-call ${SALT_OPTS} state.sls_id maas_region_packages maas

# linux.system.file only for backwards compatibility of jenkins - mcp-common-scripts
salt-call ${SALT_OPTS} state.sls jenkins.master,linux.system.file
sleep 60
salt-call -t 5 --no-color state.sls jenkins.client.plugin
systemctl restart jenkins
sleep 60
# Jenkins Mirantis theme
# FIXME move those into cluster model
git clone https://github.com/Mirantis/docker-jenkins.git
cp -r docker-jenkins/theme /var/lib/jenkins/userContent
chown -R jenkins:jenkins /var/lib/jenkins/userContent/*
# finish Jenkins setup
salt-call -t 5 --no-color state.sls jenkins.client.plugin
systemctl restart jenkins
sleep 60
salt-call -t 5 --no-color state.sls jenkins.client
systemctl restart jenkins
sleep 60
salt-call ${SALT_OPTS} state.sls jenkins.client

