#!/bin/bash -xe

# Wait for salt-master and salt-minion to wake up after restart
# since we just perform 'reboot.sh'
salt-call --timeout=120 test.ping

SALT_OPTS="-l debug -t 10 --retcode-passthrough --no-color"

salt-call saltutil.refresh_pillar
salt-call saltutil.sync_all

salt-call ${SALT_OPTS} state.sls salt
salt-call ${SALT_OPTS} state.sls linux.system.repo,linux.system.directory,linux.system.package
salt-call ${SALT_OPTS} state.sls linux.system.file
salt-call ${SALT_OPTS} state.sls docker.host
salt-call ${SALT_OPTS} state.sls docker exclude=docker.client.registry
sleep 120
salt-call ${SALT_OPTS} state.sls linux.network
salt-call ${SALT_OPTS} state.sls nginx
salt-call ${SALT_OPTS} state.sls maas.mirror
