#!/bin/bash -xe


# for Jenkins agent
add-apt-repository -y ppa:openjdk-r/ppa
apt-get update
apt-get install -y openjdk-11-jre-headless
# for fuel-devops and tcp-qa
apt-get install -y libyaml-dev libffi-dev libvirt-dev python-dev pkg-config vlan bridge-utils python-pip python3-pip virtualenv
# additional tools
apt-get install -y ebtables curl ethtool iputils-ping lsof strace tcpdump traceroute wget iptables htop \
    git jq ntpdate tree mc byobu at pm-utils genisoimage iotop zlib1g zlib1g-dev libssl-dev

# ldap
apt-get install -y ldap-auth-client nscd ldap-utils

# update kernel
apt-get install -y linux-generic-hwe-16.04




#install python3.7
cd /usr/src
wget https://www.python.org/ftp/python/3.7.9/Python-3.7.9.tgz
tar -xzvf Python-3.7.9.tgz
cd Python-3.7.9
./configure --enable-optimizations
make altinstall

# install Pyenv
apt-get install -y build-essential git libreadline-dev zlib1g-dev libssl-dev libbz2-dev libsqlite3-dev
export PYENV_ROOT=/usr/local/.pyenv/
curl https://pyenv.run | bash
command -v pyenv >/dev/null || export PATH="$PYENV_ROOT/bin:$PATH"
ln -s $(which pyenv) /usr/local/bin/pyenv
pyenv install 3.7.12
pyenv install 3.8.12
pyenv install 3.9.12
chown -R jenkins:jenkins $PYENV_ROOT