#!/bin/bash

filepath=/etc/bash_completion.d/kaas
cat > ${filepath} <<EOF
PATH=${PATH}:~/kaas-bootstrap/bin
if [ -f ~/.kube/kind-config-clusterapi ] ; then export KUBECONFIG=~/.kube/kind-config-clusterapi ; fi
if [ -f ~/kubeconfig ]; then export KUBECONFIG=~/kubeconfig ; fi
if [ -f ~/bootstrap/dev/kubeconfig ]; then export KUBECONFIG=~/bootstrap/dev/kubeconfig; fi
if [ -f ~/child.kubeconfig ]; then export KUBECONFIG=~/child.kubeconfig; fi
if [[ -f ~/clouds.yaml && -f /usr/local/bin/yq ]] ; then
  export OS_CLOUD=admin
  OS_USERNAME=\$(yq .clouds.admin.auth.username ~/clouds.yaml)
  OS_PASSWORD=\$(yq .clouds.admin.auth.password ~/clouds.yaml)
  OS_AUTH_URL=\$(yq .clouds.admin.auth.auth_url ~/clouds.yaml)
fi

echo
echo "KUBECONFIG=\${KUBECONFIG}"
echo "kubectl=\$(which kubectl)"
echo
echo "OS_USERNAME=\${OS_USERNAME}"
echo "OS_PASSWORD=\${OS_PASSWORD}"
echo
[[ -f ~/openstack_clients/bin/activate ]] && echo "OpenStack shell clients at 'source ~/openstack_clients/bin/activate'"
echo
echo "Horizon at \${OS_AUTH_URL/keystone/horizon}"
echo
EOF
