import yaml

secrets_template = {
    'apiVersion': 'v1',
    'kind': 'Secret',
    'metadata': {
        'name': 'osh-dev-hidden',
        'namespace': 'openstack',
        'labels': {
            "openstack.lcm.mirantis.com/osdpl_secret": 'true'
        }
    },

    'type': 'Opaque',
    'stringData': {
        "ca_cert": "",
        "api_cert": "",
        "api_key": ""
    }
}

data_dict = {
    'kind': 'OpenStackDeploymentSecret',
    'metadata': {
        'name': 'mosk',
        'namespace': 'openstack'},
    "spec": {
        "features": {
            "ssl": {
                "public_endpoints": {
                    "ca_cert": {
                        "value_from": {
                            "secret_key_ref": {
                                "key": "ca_cert",
                                "name": "mosk_ssl_keys"}
                        }
                    },
                    "api_cert": {
                        "value_from": {
                            "secret_key_ref": {
                                "key": "api_cert", "name": "mosk_ssl_keys"}
                        }
                    },
                    "api_key": {
                        "value_from": {
                            "secret_key_ref": {
                                "key": "api_key",
                                "name": "mosk_ssl_keys"}
                        }
                    },
                }
            }
        }
    }

}
files = {"ca_cert": "/root/cert/ca.pem",
         "api_cert": "/root/cert/server.pem",
         "api_key": "/root/cert/server-key.pem"}
for f, path in files.items():
    with open(path, "r") as certfile:
        secrets_template["stringData"][f] = certfile.read()

out_file_path = "/root/bm_mcc_mosk/child/kaas_workloads/osdpl-ssl-secrets.yaml"

with open(out_file_path, "w") as f:
    yaml.dump(secrets_template, f)
