#!/bin/bash
set -ex

if [ "$#" -ne 1 ]; then
    echo "Usage: $0 COREDNS_IP"
    exit 1
fi

export DEBIAN_FRONTEND=noninteractive
export DEBCONF_NONINTERACTIVE_SEEN=true
APT_OPTS="-y -o APT::Install-Suggests=0 -o APT::Install-Recommends=0 -o Dpkg::Options::=--force-confold -o Dpkg::Options::=--force-confdef"

apt ${APT_OPTS} install dnsmasq
service systemd-resolved stop
systemctl disable systemd-resolved
rm /etc/resolv.conf
cat > /etc/resolv.conf <<EOF
nameserver 127.0.0.1
EOF
LISTEN_ADDR=$(ip a | grep 172 | awk '{print $2}' | awk -F/ '{print $1}' | head -n1)
grep "${LISTEN_ADDR}" /etc/dnsmasq.conf || echo "listen-address=::1,127.0.0.1,${LISTEN_ADDR}" >> /etc/dnsmasq.conf
grep "mnt-bm.mirantis.net" /etc/dnsmasq.conf || echo "address=/.mnt-bm.mirantis.net/${1}" >> /etc/dnsmasq.conf
grep "server=172.18.176.6" /etc/dnsmasq.conf || echo "server=172.18.176.6" >> /etc/dnsmasq.conf
service dnsmasq restart
