#!/bin/bash -xe

LC_ALL=en_US.UTF-8
DEVOPS_VENV_PATH=/home/jenkins/fuel-devops30

if [ ! "$CHANGE_RIGHTS" ]; then
    CHANGE_RIGHTS=true
fi

if [ ! -d ${DEVOPS_VENV_PATH} ]; then
    virtualenv ${DEVOPS_VENV_PATH}
fi
if [ ! -d ${REPORT_VENV_PATH} ]; then
    virtualenv --python=python3.7 ${REPORT_VENV_PATH}
fi
if [ ! -d ${TESTMARKER_VENV_PATH} ]; then
    virtualenv --python=python3 ${TESTMARKER_VENV_PATH}
fi

# Install tcp-qa requirements
. ${DEVOPS_VENV_PATH}/bin/activate
pip install -r https://raw.githubusercontent.com/Mirantis/tcp-qa/master/tcp_tests/requirements.txt
pip install psycopg2  # workaround for setup with PostgreSQL , to keep requirements.txt for Sqlite3 only
deactivate

if [ "$CHANGE_RIGHTS" = true ]; then
  chown -R jenkins:jenkins /home/jenkins/
fi
