#!/bin/bash -xe

LC_ALL=en_US.UTF-8
DEVOPS_VENV_PATH=/home/jenkins/fuel-devops30
REPORT_VENV_PATH=/home/jenkins/venv_testrail_reporter
TESTMARKER_VENV_PATH=/home/jenkins/venv_testrail_analyzer

if [ ! -d ${DEVOPS_VENV_PATH} ]; then
    virtualenv ${DEVOPS_VENV_PATH}
fi
if [ ! -d ${REPORT_VENV_PATH} ]; then
    virtualenv ${REPORT_VENV_PATH}
fi
if [ ! -d ${TESTMARKER_VENV_PATH} ]; then
    virtualenv --python=python3 ${TESTMARKER_VENV_PATH}
fi

# Install tcp-qa requirements
. ${DEVOPS_VENV_PATH}/bin/activate
pip install -r https://raw.githubusercontent.com/Mirantis/tcp-qa/master/tcp_tests/requirements.txt
pip install psycopg2  # workaround for setup with PostgreSQL , to keep requirements.txt for Sqlite3 only
deactivate

# Install xunit2testrail
. ${REPORT_VENV_PATH}/bin/activate
#pip install xunit2testrail -U
pip install git+https://github.com/dis-xcom/testrail_reporter -U  # Removed accessing to an unexisting pastebin on srv62
deactivate

# Install testRail analyzer
. ${TESTMARKER_VENV_PATH}/bin/activate
pip install git+https://github.com/ibumarskov/testrail-reporter -U
deactivate

chown -R jenkins:jenkins /home/jenkins/
