import time

import pytest

from tcp_tests import logger
from tcp_tests import settings


LOG = logger.logger


def wa_cve_2021_20288_global_id_reclaim(reclass_actions, salt_actions):
    if reclass_actions.check_existence(
            'parameters.ceph.common.config.mon.' +
            'auth_allow_insecure_global_id_reclaim'):
        LOG.info("Skipping WA ceph set auth_allow_insecure_global_id_reclaim")
        return

    common_tgt = "I@ceph:common"
    mon_tgt = "I@ceph:mon"

    context_file = "cluster/*/ceph/common.yml"
    reclass_actions.add_bool_key(
        'parameters.ceph.common.config.mon.' +
        'auth_allow_insecure_global_id_reclaim', "False", context_file)
    salt_actions.cmd_run("cfg01*",
                         "cd /srv/salt/reclass; git add -u && "
                         "git commit --allow-empty "
                         "-m 'apply auth_allow_insecure_global_id_reclaim "
                         "parameter'")
    salt_actions.run_state("*", "saltutil.refresh_pillar")
    salt_actions.run_state(common_tgt, "state.apply", "ceph.common")
    salt_actions.cmd_run(mon_tgt, "systemctl restart ceph-mon.target")

    restart_mapping = {
        "apache2": "I@apache:server:enabled",
        "glance-api": "I@glance:server",
        "cinder-backup": "I@cinder:server",
        "cinder-scheduler": "I@cinder:server",
        "cinder-volume": "I@cinder:volume",
        "nova-compute": "I@nova:compute",
        "gnocchi-metricd": "I@gnocchi:server"
    }
    for service, target in restart_mapping.items():
        salt_actions.run_state(target, "service.restart", service)
        time.sleep(5)


class TestCephLuminousUpgrade(object):

    @pytest.mark.grab_versions
    @pytest.mark.parametrize("_", [settings.ENV_NAME])
    @pytest.mark.run_mcp_update
    def test_ceph_luminous_upgrade(self, reclass_actions, salt_actions,
                                   drivetrain_actions, show_step, _):
        """ Upgrade Ceph luminous to nautilus

        Scenario:
            1. Change parameters in reclass
            2. Run Pipeline Ceph - upgrade
        https://docs.mirantis.com/mcp/master/mcp-operations-guide/ update-upgrade/major-upgrade/ceph-upgrade/upgrade-ceph.html
        """  # noqa: E501
        salt = salt_actions
        reclass = reclass_actions
        dt = drivetrain_actions
        # #################### Prepare for upgrade #################
        show_step(1)
        reclass.add_key("parameters._param.ceph_version",
                        "nautilus",
                        "cluster/*/ceph/init.yml")
        reclass.add_key(
            "parameters._param.linux_system_repo_mcp_ceph_codename",
            "nautilus",
            "cluster/*/ceph/init.yml")
        reclass.delete_class(
            "system.linux.system.repo.mcp.apt_mirantis.ceph",
            "cluster/*/ceph/common.yml"
            )
        reclass.delete_class(
            "system.linux.system.repo.mcp.apt_mirantis.ceph",
            "cluster/*/openstack/init.yml"
            )
        reclass.delete_class(
            "system.linux.system.repo.mcp.apt_mirantis.ceph",
            "cluster/*/infra/kvm.yml"
        )
        values = reclass.get_key("classes", "cluster/*/ceph/mon.yml")
        try:
            mon_cluster_index = values.index("system.ceph.mon.cluster")
        except ValueError:
            mon_cluster_index = 0
        values.insert(mon_cluster_index+1, "system.ceph.mgr.cluster")
        reclass.add_key("classes", values, "cluster/*/ceph/mon.yml")

        salt.cmd_run("cfg01*",
                     "cd /srv/salt/reclass; git add -u && \
                         git commit --allow-empty \
                         -m 'updated repositories for Ceph upgrade'")
        salt.run_state("*", "saltutil.refresh_pillar")

        # #################### Run Ceph-upgrade #################
        show_step(2)
        job_parameters = {
            "ADMIN_HOST": 'cmn01*',
            "BACKUP_DIR": '/root',
            "BACKUP_ENABLED": True,
            "CLUSTER_FLAGS": 'noout',
            "ORIGIN_RELEASE": 'luminous',
            "STAGE_FINALIZE": True,
            "STAGE_UPGRADE_CLIENT": True,
            "STAGE_UPGRADE_MGR": True,
            "STAGE_UPGRADE_MON": True,
            "STAGE_UPGRADE_OSD": True,
            "STAGE_UPGRADE_RGW": True,
            "TARGET_RELEASE": 'nautilus',
            "WAIT_FOR_HEALTHY": True,
            "ASK_CONFIRMATION": False
        }
        job_result, job_description = dt.start_job_on_jenkins(
            job_name='ceph-upgrade',
            job_parameters=job_parameters)

        assert job_result == 'SUCCESS', job_description
        wa_cve_2021_20288_global_id_reclaim(reclass_actions, salt_actions)
