#!/bin/bash
set -x

TITLE="Comparison of tcp-qa deployments"
RIGHT_NOW=$(date +"%x %r %Z")
TIME_STAMP="Updated on $RIGHT_NOW by $USER"

list_of_envs=(
    heat-cicd-pike-dvr-sl
    heat-cicd-queens-contrail41-sl
    heat-cicd-queens-dvr-sl
    heat-cicd-pike-contrail-stb-sl
    released-heat-cicd-pike-contrail41-sl
    released-heat-cicd-pike-dvr-sl
    released-heat-cicd-queens-contrail41-sl
    released-heat-cicd-queens-dvr-sl
    bm-cicd-pike-ovs-maas
    bm-cicd-queens-ovs-maas
    bm-cicd-queens-ovs-cl-maas
    heat-bm-cicd-pike-contrail-sl
    heat-bm-cicd-queens-contrail-sl
    bm-e7-cicd-pike-ovs-maas
    bm-e7-cicd-pike-odl-maas
    bm-b300-cicd-queens-ovs-maas
    bm-b300-e7-cicd-pike-ovs-maas
)

all_parameters=(
  auditd_enabled
  barbican_enabled
  barbican_backend
  barbican_integration_enabled
  jenkins_slave_type
  updates_mirantis_version
  bmk_enabled
  ceph_enabled
  ceph_version
  cicd_enabled
  ceph_osd_backend
  ceph_osd_mode
  ceph_osd_data_disks
  ceph_osd_journal_or_block_db_disks
  ceph_osds_per_device
  ceph_osd_data_size
  ceph_osd_journal_size
  ceph_osd_block_db_size
  ceph_osd_dmcrypt
  ceph_osd_node_count
  ceph_osd_bond_mode
  ceph_hyper_converged
  rbd_monitoring_enabled
  cinder_backup_engine
  compute_padding_with_zeros
  designate_enabled
  designate_backend
  fluentd_enabled
  rsync_fernet_rotation
  gainsight_service_enabled
  galera_ssl_enabled
  internal_proxy_enabled
  ironic_enabled
  kqueen_custom_mail_enabled
  kqueen_enabled
  kubernetes_enabled
  maas_dhcp_enabled
  maas_enabled
  manila_enabled
  mcp_version
  nova_vnc_tls_enabled
  octavia_manager_cluster
  octavia_amphora_topology
  octavia_spare_amphora_pool_size
  opencontrail_api_ssl_enabled
  opencontrail_enabled
  opencontrail_version
  openldap_enabled
  openscap_enabled
  openstack_enabled
  openstack_cluster_size
  openstack_mysql_x509_enabled
  openstack_nfv_dpdk_enabled
  openstack_nfv_sriov_enabled
  openstack_network_engine
  openstack_nova_compute_nfv_req_enabled
  openstack_octavia_enabled
  openstack_ovs_dvr_enabled
  openstack_rabbitmq_x509_enabled
  openstack_version
  platform
  rabbitmq_ssl_enabled
  openstack_rabbitmq_standalone_mode
  secrets_encryption_enabled
  stacklight_enabled
  stacklight_ssl_enabled
  stacklight_version
  static_ips_on_deploy_network_enabled
  tenant_telemetry_enabled
  upstream_proxy_enabled
  version

)

function split_string
{
  str=$1

  IFS=':' #  set as delimiter
  read -r id value <<< "$str" # str is read into an array as tokens separated by IFS
  unset IFS
  echo ${value}
}


function collect_parameter
{
  env=$1
  parameter_key=$2

  key_value=$(grep -w $parameter_key: tcp_tests/templates/$env/salt-context-cookiecutter*.yaml);
  echo $(split_string "$key_value")
}

function clean
{
    str=$1
    # first, strip underscores
    CLEAN=${str//[^a-zA-Z0-9_.\/\{\}:]/}
    CLEAN=`echo -n $CLEAN | tr A-Z a-z`
  echo $CLEAN
}

function html_color
{
    str=$(clean $1)
  if [ "$str" == "False" -o "$str" == "false" ]; then
       echo "bgcolor=\"#ff9999\"";
    fi
    if [ "$str" == "True" -o "$str" == "true" ]; then
       echo "bgcolor=\"#99cc99\"";
    fi

}

function unpack_parameters
{
 for param in ${all_parameters[@]}; do
    echo "<tr>";
    echo "<td>";
    echo "$param"
    echo "</td>";
    for env in ${list_of_envs[@]}; do
      value=$(collect_parameter "$env" "$param")
      echo "<td $(html_color $value)>";
      echo $(clean $value)
      echo "</td>";
    done;
    echo "</tr>";
  done;
}

function unpack_envs
{

  echo "<tr>";
  echo "<th>"
  echo "</th>"
  for env in ${list_of_envs[@]}; do
    echo "<th>";
    echo "$env"
    echo "</th>";
  done;
  echo "</tr>";

}

function write_page
{
  cat <<- _EOF_
      <html>
          <head>
              <title>$TITLE</title>
          </head>
        <body>
          <h1>$TITLE</h1>
          <p>$TIME_STAMP</p>
          <table border=1 style="border-collapse:collapse;border-spacing:0">
            $(unpack_envs)
          $(unpack_parameters)
          </table>
        </body>
      </html>
_EOF_
}


filename=report.html

write_page > $filename