
@NonCPS
def getPluginList(){
  def pluginList = new ArrayList(Jenkins.instance.pluginManager.plugins)
  def pluginListText = ""
  pluginList.each{
    plugin ->
      pluginListText += """${plugin.getShortName()}.hpi\n"""
  }
  return pluginListText
}

node('sre-team-infra') {
  timestamps() {
    ansiColor('xterm') {
      stage('Checkout') {
        checkout scm
      }
      storageDir = "${WORKSPACE}/storage"
      stage('Prepare storage dir'){
        sh "rm -rf ${storageDir} && mkdir -p ${storageDir}"
      }
      stage('Generate plugin urls'){
        pluginList = getPluginList()
        writeFile file: "${storageDir}/plugin_list.txt", text: "${pluginList}"
      }
      stage('Generate backup archive'){
        sh 'bash jobs/backups/sre-jenkins-backup.sh'
      }
      stage('Upload backups to remote hosts'){
        remoteHosts = ['172.19.119.254', 'srv02-srt.srt.mirantis.net', 'srv08-srt.infra.mirantis.net']
        errCount = 0
        sshagent(credentials: ['maintenance-team-ssh']) {
          remoteHosts.each{ host ->
            try {
              sh "ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null jenkins@${host} mkdir -p /home/jenkins/sre-jenkins-backups"
              sh "rsync -avz ${storageDir}/*.tar.gz -e 'ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null' jenkins@${host}:/home/jenkins/sre-jenkins-backups/"
            } catch (Exception e) {
                errCount+=1
            }
            if (remoteHosts.size() == errCount) {
             throw Exception('All remote hosts are not reachable!')
            }
          }
        }
      }
    }
  }
}
