#!/bin/bash -ex
set -ex
cd "$(dirname "$0")"
DATE=$(date +%F-%H%M%S)
BACKUP_MAIN_DIR="${JENKINS_HOME}/jenkins-backups/"
STORAGE_DIR="${WORKSPACE:?}/storage/"
mkdir -p "${BACKUP_MAIN_DIR:?}/${DATE}"
rm -f "${BACKUP_MAIN_DIR}/${DATE}.tar.gz"
rsync --exclude-from="${WORKSPACE}/jobs/backups/jenkins-rsync.excludes" -avzq "${JENKINS_HOME}" "${BACKUP_MAIN_DIR:?}/$DATE" --info=progress2
mv "${STORAGE_DIR}/plugin_list.txt" "${BACKUP_MAIN_DIR}/${DATE}"
tar -czf "${STORAGE_DIR}/sre-jenkins-backup-${DATE}.tar.gz" -C "${BACKUP_MAIN_DIR}" "${DATE}"

