#!/bin/bash
set -ex
source /root/bm_mcc_mosk/seed/env_vars.sh

pushd /root/
  wget https://binary.mirantis.com/releases/get_container_cloud.sh
  chmod 0755 get_container_cloud.sh
  ./get_container_cloud.sh
  cp /root/mirantis.lic kaas-bootstrap/
popd

/root/kaas-bootstrap/bootstrap.sh bootstrapv2

KAAS_RELEASE=$(yq .spec.providerSpec.value.kaas.release /root/kaas-bootstrap/templates/bm/cluster.yaml.template)
MKE_RELEASE=$(yq .spec.providerSpec.value.release /root/kaas-bootstrap/templates/bm/cluster.yaml.template)
sed -i "s/%MKE_RELEASE%/${MKE_RELEASE}/" /root/bm_mcc_mosk/kaas-mgmt/cluster.yaml
sed -i "s/%KAAS_RELEASE%/${KAAS_RELEASE}/" /root/bm_mcc_mosk/kaas-mgmt/cluster.yaml

export KUBECONFIG=/root/.kube/kind-config-clusterapi
pushd /root/bm_mcc_mosk/kaas-mgmt
 /root/kaas-bootstrap/bin/kubectl apply -f bootstrapregion.yaml && sleep 2
 /root/kaas-bootstrap/bin/kubectl apply -f serviceuser.yaml && sleep 2
 /root/kaas-bootstrap/bin/kubectl apply -f cluster.yaml && sleep 2
 /root/kaas-bootstrap/bin/kubectl apply -f baremetalhostprofiles.yaml && sleep 2
 /root/kaas-bootstrap/bin/kubectl apply -f ipam-objects.yaml && sleep 2
 /root/kaas-bootstrap/bin/kubectl apply -f baremetalhosts.yaml && sleep 2
 /root/kaas-bootstrap/bin/kubectl apply -f metallbconfig.yaml && sleep 2
 /root/kaas-bootstrap/bin/kubectl apply -f machines.yaml && sleep 2
popd

set +x

retry=60
interval=60

counter=0
while (( counter++ < retry )) ; do
  sleep $interval
  avail_count=$(/root/kaas-bootstrap/bin/kubectl get bmh -o go-template='{{- range .items -}} {{.status.provisioning.state}}{{"\n"}} {{- end -}}' | (grep -c available || /bin/true))
  echo "loop=${counter}, available state=${avail_count}"
  if (( avail_count == 3 )); then
    break
  fi
done
if (( counter > retry )) ; then
  echo "Not all nodes are available after timeout"
  exit 1
fi

counter=0
while (( counter++ < retry )) ; do
  sleep $interval
  status=$(/root/kaas-bootstrap/bin/kubectl get bootstrapregions -o go-template='{{(index .items 0).status.ready}}{{"\n"}}')
  echo "loop=${counter}, status=${status}"
  if [[ "$status" == "true" ]]; then
    break
  fi
done
if (( counter > retry )) ; then
  echo "BootstrapRegion timed out"
  exit 1
fi

/root/kaas-bootstrap/container-cloud bootstrap approve all

counter=0
retry=90
while (( counter++ < retry )) ; do
  sleep $interval
  status=$(/root/kaas-bootstrap/bin/kubectl get cluster kaas-mgmt  -o go-template='{{.status.providerStatus.ready}}{{"\n"}}')
  echo "loop=${counter}, status=${status}"
  if [[ "$status" == "true" ]]; then
    break
  fi
done
if (( counter > retry )) ; then
  echo "MGMT Cluster deployment timed out"
  exit 1
fi
cd
set -x
/root/kaas-bootstrap/container-cloud get cluster-kubeconfig --cluster-name kaas-mgmt --kubeconfig-output /root/kubeconfig
echo r00tme | /root/kaas-bootstrap/container-cloud bootstrap user add --username root --roles global-admin,management-admin,reader,writer,operator --kubeconfig kubeconfig --password-stdin
/root/kaas-bootstrap/bin/kind delete cluster -n clusterapi
unset KUBECONFIG

bash /root/bm_mcc_mosk/utils/update_bash_autocompletion_kaas.sh
