node('sre-team-infra') {
    timestamps() {
        ansiColor('xterm') {
            tmp_jenkins_config = '/dev/shm/sre-jenkins-job-builder.ini'
            stage('Checkout') {
                checkout scm
            }
            stage('Prepre venv'){
                sh """
                if [ ! -d .venv ]; then
                  echo "Can't find python virtual env, installing"
                  virtualenv -p python3 .venv
                fi
                if [ -z "\$(./.venv/bin/pip freeze | grep  jenkins-job-builder)" ]; then
                   ./.venv/bin/pip install 'jenkins-job-builder>=2.0.0.0b2' dataclasses 'requests==2.25.0'
                fi
                """
            }
            stage('Prepre config'){
                withCredentials([usernamePassword(credentialsId: 'jenkins-job-builder',
                    passwordVariable: 'jpass', usernameVariable: 'juser')]) {
                    sh """
                    cp jobs/config/sre-jenkins-job-builder-example.ini ${tmp_jenkins_config}
                    sed -i "s/user=some_user/user=\${juser}/g" ${tmp_jenkins_config}
                    sed -i "s/password=some_password/password=\${jpass}/g" ${tmp_jenkins_config}
                    sed -i "s|url=.*|url=${env.JENKINS_URL}|" ${tmp_jenkins_config}
                    """
                }
            }
            stage('Deploy jobs'){
            sh """
            cd jobs
            ../.venv/bin/jenkins-jobs --conf ${tmp_jenkins_config} test ./
            """
            if ("${env.DRY_RUN}" != "true") {
                sh """
                cd jobs
                ../.venv/bin/jenkins-jobs --conf ${tmp_jenkins_config} update ./
                """
                }
            sh """rm ${tmp_jenkins_config}"""
            }
        }
    }
}