@Library('tcp-qa')_

import groovy.xml.XmlUtil

common = new com.mirantis.mk.Common()
shared = new com.mirantis.system_qa.SharedPipeline()

NODE_LABEL = env.NODE_LABEL ?: "sre-team-infra"
MAINTENANCE_TEAM_SSH_ID = env.MAINTENANCE_TEAM_SSH_ID ?: 'maintenance-team-ssh'
//IPMI_CREDS = 'lab_engineer' // base bm lab
seed_ext_ip = env.SEED_EXT_IP ?: '172.16.180.2'
ssh_params = "-o ConnectTimeout=20 -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null"
seed_cmd = "ssh ${ssh_params} root@${seed_ext_ip}"
kubectl_openstack_cmd = "ssh ${ssh_params} root@${seed_ext_ip} /root/kaas-bootstrap/bin/kubectl --kubeconfig /root/child.kubeconfig -n openstack "
connect_phoronix_string = ""
phoronix_package_version = env.PHORONIX_PACKAGE ?: "phoronix-test-suite-10.8.4.tar.gz"
phoronix_clients_count = env.PHORONIX_CLIENT_COUNT?: "4"


timeout(time: 6, unit: 'HOURS') {
  timestamps {
    node ("${NODE_LABEL}") {
      checkout scm
      shared.update_working_dir()
      sshagent(credentials: ['maintenance-team-ssh']) {
        stage("Phoronix prepare server"){
            sh "${seed_cmd} sudo apt-get install php-cli php-xml php-sqlite3 php-zip sqlite3 -y"
            sh "${seed_cmd} wget -N https://phoronix-test-suite.com/releases/${phoronix_package_version}"
            sh "${seed_cmd} tar -zxf ${phoronix_package_version} >> extract_${phoronix_package_version}.log"
            sh "${seed_cmd} \"cd phoronix-test-suite; bash install-sh\""
            sh "${seed_cmd} cp phoronix-test-suite/deploy/phoromatic-systemd/phoromatic-server.service /etc/systemd/system"
            sh "${seed_cmd} cp phoronix-test-suite/deploy/phoromatic-systemd/phoronix-result-server.service /etc/systemd/system"
            sh "${seed_cmd} phoronix-test-suite system-info"
            sh "${seed_cmd} \"sed -i 's/<RemoteAccessPort>RANDOM/<RemoteAccessPort>8877/' /etc/phoronix-test-suite.xml\""
            sh "${seed_cmd} systemctl daemon-reload"
            sh "${seed_cmd} systemctl start phoromatic-server.service"
            sh "${seed_cmd} systemctl start phoronix-result-server.service"
            sh "${seed_cmd} \"curl --data 'seed_accountid=&register_username=sustaining&register_password=sustaining&register_password_confirm=sustaining&register_email=drivetrain-eng%40mirantis.com' http://172.16.180.2:8877/?register\""
            account_id_cmd = "sqlite3 /var/lib/phoronix-test-suite/phoromatic/phoromatic.db 'SELECT AccountID FROM 'phoromatic_account_settings' LIMIT 1;'"
            account_id = sh(returnStdout: true, script: "${seed_cmd} \"${account_id_cmd}\"").trim()
        }
        check_clouds_yaml = sh(returnStdout: true, script: "${seed_cmd} \"test -f /root/clouds.yaml && echo true || echo false\"" ).trim()
        if(check_clouds_yaml != 'true'){
          stage("Openstack client prepare"){
            sh """
              ${seed_cmd} \"source bm_mcc_mosk/utils/openstack_client_activate.sh;
              mkdir -p ~/.config/openstack;
              export KUBECONFIG=/root/child.kubeconfig;
              /root/kaas-bootstrap/bin/kubectl -n openstack-external get secrets openstack-identity-credentials -o jsonpath='{.data.clouds\\.yaml}' | base64 -d > /root/clouds.yaml;
              ln -sf /root/clouds.yaml /root/.config/openstack/clouds.yaml\"
            """
          }
        }
        stage("Create instances Phoronix clients "){
          phoronix_client_yaml = "bm_mcc_mosk/child/openstack_workload/phoronix_client/phoronix-client.yml"
          create_client_cmd = """
            source bm_mcc_mosk/utils/openstack_client_activate.sh;
            export KUBECONFIG=/root/child.kubeconfig;
            openstack --insecure flavor create --public m1.p_test --ram 8192 --disk 5 --vcpus 4;
            openstack --insecure stack create -t ${phoronix_client_yaml} --parameter client_count=${phoronix_clients_count} --parameter phoronix_account_id=${account_id} --parameter phoronix_version=${phoronix_package_version} phoronix_client --wait
          """
          sh "${seed_cmd} \"${create_client_cmd}\"" //create clients stack
          sh "${seed_cmd} \"source bm_mcc_mosk/utils/openstack_client_activate.sh; openstack --insecure stack list --property 'Stack Name'=phoronix_client\"" //view stack status
        }
      } //sshagent
    } //node
  } //timestamps
} //timeout