/*
*   DEPLOY_EMPTY_NODE             Add extra node to heat stack. Node without a role and with salt-minion
*/

@Library('tcp-qa')_

def common = new com.mirantis.mk.Common()
def shared = new com.mirantis.system_qa.SharedPipeline()

def batch_size = env.BATCH_SIZE ?: ''
def dist_upgrade_nodes = "${env.DIST_UPGRADE_NODES}" != "false" ? true : false
env.LAB_CONFIG_NAME = 'cookied-model-generator'

timeout(time: 23, unit: 'HOURS') {
  node ("${NODE_NAME}") {
    env.slave_workdir = pwd()

    def inject_env_vars = [
        'VENV_PATH=/home/jenkins/fuel-devops30',
        "ENV_NAME=swarm_model_${BUILD_NUMBER}",
        'LAB_CONFIG_NAME=cookied-model-generator',
        "SALT_STEPS_PATH=templates/${LAB_CONFIG_NAME}/salt_${LAB_CONTEXT_NAME}.yaml",
        'TEST_GROUP=test_generate_model',
        'PYTHONIOENCODING=UTF-8',
        'MAKE_SNAPSHOT_STAGES=false',
        'DEVOPS_LOCK_FILE=/run/lock/devops_lock',
    ]

    withEnv(inject_env_vars) {
      withCredentials([[$class: 'SSHUserPrivateKeyBinding',
                         credentialsId : 'f4fb9dd6-ba63-4085-82f7-3fa601334d95',
                         keyFileVariable: "COOKIECUTTER_TEMPLATES_REPOSITORY_KEY_PATH"]]) {
        try {
          checkout scm
          sshagent(credentials: ['f4fb9dd6-ba63-4085-82f7-3fa601334d95']) {
            sh "/bin/bash ./jobs/pipelines/cookied-model-generator.sh"
          }
        } finally {
          dir("${env.slave_workdir }") {
            archiveArtifacts artifacts: 'tcp_tests/*.log,tcp_tests/*.tar.gz,tcp_tests/*.xml'
            venv_cmd = "source ${VENV_PATH}/bin/activate"
            if (env.SHUTDOWN_ENV_ON_TEARDOWN.toBoolean()){
              sh "${venv_cmd} && dos.py destroy ${ENV_NAME}"
            }
            if (env.ERASE_ENVIRONMENT_AFTER_BUILD.toBoolean()){
              sh "${venv_cmd} && dos.py erase ${ENV_NAME}"
            }
          }
        } //try
      } // withCredentials
    } // withEnv
  } // node
} // timeout
