#!/bin/bash
set -e
cd "$(dirname "$0")"
### Prepare
if [ ! -d .venv ]; then
  echo "Can't find python virtal env, installing"
  virtualenv -p python3 .venv
fi
if [ -z "$(./.venv/bin/pip freeze | grep  jenkins-job-builder)" ]; then
   ./.venv/bin/pip install 'jenkins-job-builder>=2.0.0.0b2'
fi

### Check ini file
CFG_FILE="${HOME}/.config/sre-jenkins-job-builder.ini"
if [ ! -f "$CFG_FILE" ]; then
   cat << EOF
Can't find configuration file $CFG_FILE
Please create this file from this template with your user and password
For security reasons do not use password from LDAP and
use API key generated in http://sre-ci.scc.mirantis.net/user/\$USER/configure.
File example:
EOF
   cat config/sre-jenkins-job-builder-example.ini
   exit 1
fi
# ./.venv/bin/jenkins-jobs --conf $CFG_FILE test ./
./.venv/bin/jenkins-jobs --conf $CFG_FILE update ./