#!/bin/bash

while [ "$#" -gt 0 ]; do
  case "$1" in
    -n|--namespace) NAMESPACE="$2"; shift 2;;
    -n=*|--namespace=*) NAMESPACE="${1#*=}"; shift 1;;

    -c|--child-name) CHILD_NAME="$2"; shift 2;;
    -c=*|--child-name=*) CHILD_NAME="${1#*=}"; shift 1;;

    -f|--force) FORCE="true"; shift 1;;

    --*|-*|*) echo "unknown option: $1"; help; exit 1;;
  esac
done


function wait_threads() {
  while [[ $(jobs -r -p | wc -l) -gt 0 ]]; do
    sleep 0.1
  done
}

function wait_threads_limit() {
  local LIMIT=$1
  while [[ $(jobs -r -p | wc -l) -ge $LIMIT ]]; do
    sleep 0.1
  done
}

#function k_patch() {
#  local TYPE=$1
#  local ITEM=$2
#  local PATCH=$3
#
#  echo $TYPE
#  echo $ITEM
#  echo $PATCH
#  echo kubectl -n ${NAMESPACE} patch $TYPE $ITEM --type merge -p $PATCH 2>/dev/null
#
#  kubectl -n ${NAMESPACE} patch $TYPE $ITEM --type merge -p $PATCH 2>/dev/null || true
#}

#function k_delete() {
#  local TYPE=$1
#  local ITEM=$2
#
#  kubectl -n ${NAMESPACE} delete $TYPE $ITEM || true
#}


echo "= Cleanup env ${NAMESPACE}"

BMH=$(kubectl -n ${NAMESPACE} get bmh -o json | jq '.items[].metadata.name' -r)
for bmh in $BMH; do
  if [[ $FORCE ]]; then
    echo "= Path baremetalhost: $bmh"
    kubectl -n ${NAMESPACE} patch bmh $bmh '{"spec": {"automatedCleaningMode": "disabled"}}' 2>/dev/null || true
  fi
done

MACHINE=$(kubectl -n ${NAMESPACE} get machine -o json | jq '.items[].metadata.name' -r)
for machine in $MACHINE; do
  echo "= Delete machines: $machine"
  if [[ $FORCE ]]; then
    kubectl -n ${NAMESPACE} patch machine $machine --type merge -p '{"metadata": {"annotations": {"kaas.mirantis.com/validate": "false"}}}' 2>/dev/null || true
    kubectl -n ${NAMESPACE} patch machine $machine --type merge -p '{"metadata": {"finalizers": null}}' 2>/dev/null || true
    sleep 1
  fi
  kubectl -n ${NAMESPACE} delete machine $machine &
  sleep 3 && kubectl -n ${NAMESPACE} patch machine $machine --type merge -p '{"metadata": {"finalizers": null}}' 2>/dev/null || true
  wait_threads
done

for bmh in $BMH; do
  echo "= Delete baremetalhost: $bmh"
  if [[ $FORCE ]]; then
    kubectl -n ${NAMESPACE} patch bmh $bmh --type merge -p '{"metadata": {"annotations": {"kaas.mirantis.com/validate": "false"}}}' 2>/dev/null || true
    kubectl -n ${NAMESPACE} patch bmh $bmh --type merge -p '{"spec": {"consumerRef": null}}' 2>/dev/null || true
    kubectl -n ${NAMESPACE} patch bmh $bmh --type merge -p '{"metadata": {"finalizers": null}}' 2>/dev/null || true
  fi
  kubectl -n ${NAMESPACE} delete bmh $bmh &
  sleep 1 && kubectl -n ${NAMESPACE} patch bmh $bmh --type merge -p '{"metadata": {"finalizers": null}}' 2>/dev/null || true
  wait_threads
done

SECRET=$(kubectl -n ${NAMESPACE} get secret -o json | jq '.items[].metadata.name' -r)
for secret in $SECRET; do
  echo "= Delete secret: $secret"
  if [[ $FORCE ]]; then
    kubectl -n ${NAMESPACE} patch secret $secret --type merge -p '{"metadata": {"annotations": {"kaas.mirantis.com/validate": "false"}}}' 2>/dev/null || true
    kubectl -n ${NAMESPACE} patch secret $secret --type merge -p '{"metadata": {"finalizers": null}}' 2>/dev/null || true
  fi
  kubectl -n ${NAMESPACE} delete secret $secret &
  sleep 1 && kubectl -n ${NAMESPACE} patch secret $secret --type merge -p '{"metadata": {"finalizers": null}}' 2>/dev/null || true
  wait_threads
done

CLUSTER=$(kubectl -n ${NAMESPACE} get cluster -o json | jq '.items[].metadata.name' -r)
for cluster in $CLUSTER; do
  echo "= Delete cluster: $cl"
  if [[ $FORCE ]]; then
    kubectl -n ${NAMESPACE} patch cluster $cluster --type merge -p '{"metadata": {"annotations": {"kaas.mirantis.com/validate": "false"}}}' 2>/dev/null || true
    kubectl -n ${NAMESPACE} patch cluster $cluster --type merge -p '{"metadata": {"finalizers": null}}' 2>/dev/null || true
  fi
  kubectl -n ${NAMESPACE} delete cluster $cluster || true
done

wait_threads

echo "= Delete namespace: ${NAMESPACE}"
kubectl delete ns ${NAMESPACE} || true
kubectl -n kaas scale deployment/ironic --replicas=0
sleep 10
kubectl -n kaas scale deployment/ironic --replicas=1
(kubectl api-resources --verbs=list --namespaced -o name | xargs -n 1 kubectl get --show-kind --ignore-not-found -n "${NAMESPACE}" ) || true
echo "Done."
