import sys
import yaml

assert len(sys.argv) > 1
internal_ip = sys.argv[1]
domain = "mnt-bm.mirantis.net"
template = """
{domain}:53 {{
    errors
    cache 30
    forward . {internal_ip}
}}"""
with open("/root/coredns.conf", "r") as f:
    content = yaml.safe_load(f)
content['data']['Corefile'] += template.format(
    domain=domain, internal_ip=internal_ip)

out_file_path = "/root/coredns.patched.conf"
with open(out_file_path, "w") as f:
    yaml.safe_dump(content, f)
