set -e
rm -rf /root/cert && mkdir -p /root/cert && pushd /root/cert

tee ca-config.json << EOF
{
  "signing": {
    "default": {
      "expiry": "8760h"
    },
    "profiles": {
      "kubernetes": {
        "usages": [
          "signing",
          "key encipherment",
          "server auth",
          "client auth"
        ],
        "expiry": "8760h"
      }
    }
  }
}
EOF

tee ca-csr.json << EOF
{
  "CN": "kubernetes",
  "key": {
    "algo": "rsa",
    "size": 2048
  },
  "names":[{
    "C": "EU",
    "ST": "CZ",
    "L": "DC",
    "O": "Mirantis",
    "OU": "EU BM 2401"
  }]
}
EOF

tee server-csr.json << EOF
{
    "CN": "*.mnt-bm.mirantis.net",
    "hosts":     [
        "*.mnt-bm.mirantis.net"
    ],
    "key":     {
        "algo": "rsa",
        "size": 2048
    },
    "names": [    {
        "C": "EU",
        "L": "DC",
        "ST": "CZ"
    }]
}
EOF
cfssl gencert -initca ca-csr.json | cfssljson -bare ca
cfssl gencert -ca=ca.pem -ca-key=ca-key.pem --config=ca-config.json -profile=kubernetes server-csr.json | cfssljson -bare server
popd
python3 /root/bm_mcc_mosk/utils/tsl_to_yaml.py