@Library('tcp-qa')_

import groovy.xml.XmlUtil

common = new com.mirantis.mk.Common()
shared = new com.mirantis.system_qa.SharedPipeline()

NODE_LABEL = env.NODE_LABEL ?: "sre-team-infra"
MAINTENANCE_TEAM_SSH_ID = env.MAINTENANCE_TEAM_SSH_ID ?: 'maintenance-team-ssh'
//IPMI_CREDS = 'lab_engineer' // base bm lab
seed_ext_ip = env.SEED_EXT_IP ?: '172.16.180.2'
ssh_params = "-o ConnectTimeout=20 -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null"
kubectl_openstack_cmd = "ssh ${ssh_params} root@${seed_ext_ip} /root/kaas-bootstrap/bin/kubectl --kubeconfig /root/child.kubeconfig -n openstack "


timeout(time: 6, unit: 'HOURS') {
  timestamps {
    node ("${NODE_LABEL}") {
      checkout scm
      shared.update_working_dir()
      sshagent(credentials: ['maintenance-team-ssh']) {
        withCredentials(
        [[$class: 'SSHUserPrivateKeyBinding',
          keyFileVariable: "MAINTENANCE_TEAM_SSH_KEY",
          credentialsId: MAINTENANCE_TEAM_SSH_ID,
          usernameVariable: "MAINTENANCE_TEAM_SSH_USERNAME"]]) {
          stage("Archive artifacts"){
            sh "${kubectl_openstack_cmd} apply -f /root/bm_mcc_mosk/child/kaas_workloads/tempest-pvc-storage.yaml"
            sleep 60
            ssh_cmd = "ssh ${ssh_params} root@${seed_ext_ip} "
            sh "${ssh_cmd} '/root/kaas-bootstrap/bin/kubectl --kubeconfig /root/child.kubeconfig -n openstack cp tempest-test-results-pod:var/lib/tempest/data/ /root/tempest_log/'"
            sh "scp -r -v ${ssh_params} root@${seed_ext_ip}:/root/tempest_log ."
            sh "tar -czvf tempest_log/tempest_full.tar.gz tempest_log/tempest.log"
            archiveArtifacts artifacts: "openstack_credentials.yaml, tempest_log/*/tempest.log, tempest_log/tempest_full.tar.gz"
            sh "${kubectl_openstack_cmd} delete pod tempest-test-results-pod"
            if( env.DELETE_TEMPEST_POD == true ){
              sh "${kubectl_openstack_cmd} patch osdpl osh-dev --type merge -p '{\\\"spec\\\":{\\\"features\\\":{\\\"services\\\":[]}}}'"
            }
          }
        } //withCredentials
      } //sshagent
    } //node
  } //timestamps
} //timeout