#!/bin/bash

. ${CUSTOM_REPO_VENV_PATH}/bin/activate

set -eo pipefail;

if [ -z "${DATE}" ]; then
  d=$(date +%Y-%m-%d)
  export DATE_REPORT="$(date +%Y-%m-%d)"
else
  export DATE_REPORT=${DATE}
fi

export TESTRAIL_URL="https://mirantis.testrail.com"
#export TESTRAIL_USER_EMAIL="drivetrain-eng@mirantis.com"
#export TESTRAIL_USER_KEY=""
export TESTRAIL_PROJECT='Mirantis Cloud Platform'
#export JIRA_USER="mcp-qa-bot@mirantis.com"
#echo $JIRA_PWD
######### Run Report Generator ##########

for day in $DATE_REPORT; do

if [ -z "${PLAN_NAME}" ]; then
  export TESTRAIL_PLAN="[2019.2.0-update]System-${REPOSITORY_SUITE}-"${day}
else
  export TESTRAIL_PLAN=${PLAN_NAME}
  echo ${PLAN_NAME}
fi

[ -d ${VENV_PATH} ] || virtualenv  ${VENV_PATH}
. ${VENV_PATH}/bin/activate
pip install testrail==0.3.14 jira==2.0.0 functools32==3.2.3.post2

python tcp_tests/report.py create-report \
    --testrail-host "$TESTRAIL_URL" \
    --testrail-user "$TESTRAIL_USER_EMAIL" \
    --testrail-user-key "$TESTRAIL_USER_KEY" \
    --testrail-plan $TESTRAIL_PLAN \
    --testrail-project "$TESTRAIL_PROJECT" \
    --out-type html \
    --push-to-testrail \
    --sort-by fails \
    --jira-host https://mirantis.jira.com/ \
    --jira-user $JIRA_USER \
    --jira-password $JIRA_PWD > ${day}_system_bug_report_$(date +%Y%m%d%H%M%S).html && ret=0 || ret=1

echo "Report for ${TESTRAIL_PLAN} finished with ${ret}"

#export TESTRAIL_PLAN="[MCP1.1]BVT-"${day}

#python tcp-qa/tcp_tests/report.py create-report \
#    --testrail-host "$TESTRAIL_URL" \
#    --testrail-user "$TESTRAIL_USER_EMAIL" \
#    --testrail-user-key "$TESTRAIL_USER_KEY" \
#    --testrail-plan $TESTRAIL_PLAN \
#    --testrail-project "$TESTRAIL_PROJECT" \
#    --out-type html \
#    --push-to-testrail \
#    --sort-by fails \
#    --jira-host https://mirantis.jira.com/ \
#    --jira-user $JIRA_USER \
#    --jira-password $JIRA_PWD > ${day}_bvt_bug_report_$(date +%Y%m%d%H%M%S).html && ret=0 || ret=1

#echo "Report for ${TESTRAIL_PLAN} finished with ${ret}"

done