node('sre-team-infra') {
    timestamps() {
        ansiColor('xterm') {
            tmp_jenkins_config = '/dev/shm/sre-jenkins-job-builder.ini'
            stage('Checkout') {
                checkout scm
            }
            stage('Codenarc') {
                try {
                    sh '''#!/bin/bash -ex
                    docker run --rm \
                    -t --user "\$(id -u):\$(id -g)" \
                    -v ${WORKSPACE}:/ws \
                    docker-prod-local.docker.mirantis.net/infra/codenarc:latest \
                    -rulesetfiles="rulesets/basic.xml" \
                    -maxPriority1Violations=0 \
                    -maxPriority2Violations=0 \
                    -maxPriority3Violations=0 \
                    -report=console \
                    -report=html:/ws/report.html 2>&1 \
                    | tee report.log
                    if [ "${PIPESTATUS[0]}" != '0' ]; then
                        exit 1
                    fi
                    '''
                }
                finally {
                    archiveArtifacts \
                    artifacts: "**/report.html",
                    allowEmptyArchive: false
                }
            }
            stage ("Test python with pep8"){
                sh """
                set -e
                tox
                """
            }
        }
    }
}