#!/bin/bash
# export REMOTE_JENKINS='172.19.112.216'
set -eox pipefail;
# Temporary call to global SCRIPT_JENKINS_IP while migrating jenkins
export REMOTE_JENKINS="${SCRIPT_JENKINS_IP:-sre-ci.scc.mirantis.net}"

if [ ! -n "$LAB_CONTEXT_NAME" ]; then
  echo 'LAB_CONTEXT_NAME is not set!
    This name will be used:
    - to find the template file tcp_tests/templates/cookied-model-generator/salt_${LAB_CONTEXT_NAME}.yaml
    - to set the salt model cluster name
    - to make DOMAIN_NAME=${LAB_CONTEXT_NAME}.local
  ';
  exit 1
fi


if [ -n "$TCP_QA_REVIEW" ]; then
	git fetch https://gerrit.mcp.mirantis.com/mcp/tcp-qa $TCP_QA_REVIEW && git checkout FETCH_HEAD
fi

. ${VENV_PATH}/bin/activate

if [ "$ERASE_EXISTING_ENVIRONMENT" = "true" ]; then
    dos.py erase $ENV_NAME || true
fi

cd tcp_tests

sed -i 's/%LOGIN%/rHm22xBV9K/' templates/${LAB_CONTEXT_NAME}/salt-context-cookiecutter*
sed -i 's/%PASS%/az9Gq7Wq4jRic29YWP/' templates/${LAB_CONTEXT_NAME}/salt-context-cookiecutter*

rm -f ./*.tar.gz

#MODEL_FILENAME=model_${CLUSTER_NAME}_${BUILD_NUMBER}.tar.gz
MODEL_FILENAME=model_${ENV_NAME}.tar.gz
if [[ -f $MODEL_FILENAME ]]; then
   rm $MODEL_FILENAME
fi

####################
# Generate the model
git config  user.name "tester"
git config  user.email "tester@example.com"

py.test --junit-xml=deploy_generate_model.xml -k ${TEST_GROUP}


########################################################
# Upload the generated model to the repository on cz8133

# Create a directory where the created model will be unpacked
rm -rf ./model
mkdir -p ./model

# Create remote repository
ssh jenkins@${REMOTE_JENKINS} "
  if [[ ! -d /home/jenkins/salt-models/${LAB_CONTEXT_NAME}.git ]]; then
    mkdir -p /home/jenkins/salt-models/${LAB_CONTEXT_NAME}.git;
    cd /home/jenkins/salt-models/${LAB_CONTEXT_NAME}.git;
    git init --bare;
    cp hooks/post-update.sample hooks/post-update;
  fi"

cd ./model

# Prepare the repository in the ./model
git init
git remote add integration ssh://jenkins@${REMOTE_JENKINS}/home/jenkins/salt-models/${LAB_CONTEXT_NAME}.git
git pull integration ${REPOSITORY_SUITE} || true
git checkout -b ${REPOSITORY_SUITE}
git rm -rf . || true   # remove previous content from the working dir

# unpack new model into ./model dir
tar -xzf ../${MODEL_FILENAME} -C ./
# Add reclass-system submodule
git submodule add https://gerrit.mcp.mirantis.com/salt-models/reclass-system classes/system/
cd classes/system
git checkout ${SALT_MODELS_SYSTEM_COMMIT}
cd ../..

# The directory "classes/service" is created at bootstrap time
# and cannot be commited to the repository automatically.
# It is not needed in the repo because contains only symlinks.
cat << EOF > ./.gitignore
classes/service
EOF

# create a commit with new model (if any change exists)
git add -A
git commit -m "${LAB_CONTEXT_NAME}@${REPOSITORY_SUITE} generated at $(date +%Y-%m-%d/%H-%M)

REPOSITORY_SUITE=${REPOSITORY_SUITE}
SALT_MODELS_SYSTEM_COMMIT=${SALT_MODELS_SYSTEM_COMMIT}
COOKIECUTTER_TEMPLATE_COMMIT=${COOKIECUTTER_TEMPLATE_COMMIT}
"

# Push new commit to the ${REMOTE_JENKINS} repository
git push integration ${REPOSITORY_SUITE}

echo "######################################################################################################################"
echo "#"
echo "# Clone the model into the tests:  git clone http://${REMOTE_JENKINS}:8098/${LAB_CONTEXT_NAME}.git -b ${REPOSITORY_SUITE}"
echo "#"
echo "######################################################################################################################"

