from django.conf import settings
from jira import JIRA, Issue

jira = JIRA(
    server=settings.JIRA_SERVER,
    basic_auth=(settings.JIRA_USER, settings.JIRA_PASSWORD),
)


class JiraIssue:
    def __init__(self, key: str):
        self.key = key
        self._issue = None
        self._style_prod_area = (
            "background-color:aliceblue;border-color:CornflowerBlue;"
        )
        self._style_prod_text = "color:blue"

    @property
    def issue(self) -> Issue:
        if self._issue:
            return self._issue
        self._issue = jira.issue(self.key)
        return self._issue

    def get_link(self) -> str:
        return f"{settings.JIRA_SERVER}/browse/{self.issue.key}"

    def html(self) -> str:
        if self.issue.fields.status.name in ["Completed", "Released"]:
            self._style_prod_area = "background-color:red;border-color:black;"
            self._style_prod_text = "color:white"
        return (
            f"<div style='display:inline-block;border:1px solid;"
            f"{self._style_prod_area}"
            f"border-radius:5px;padding:2px;'>"
            f"<a style={self._style_prod_text} href='{self.get_link()}'>"
            f"{self.key}: {self.issue.fields.summary[:50]}</a>"
            f"<b style={self._style_prod_text}> "
            f"{self.issue.fields.status.name}</b>"
            f"</div>"
        )
