from os import environ
import yaml
from pathlib import Path
import logging

LOG = logging.getLogger("rp_reporter")

RP_CONFIG_FILE = environ.get("RP_CONFIG_FILE") or (Path.home() / ".reportportal_config")

def from_conf(key_name):
    if not Path(RP_CONFIG_FILE).exists():
        LOG.info(f"Can't get {key_name} because config file "
                    f"not found: {RP_CONFIG_FILE}")
        return None
    with open(RP_CONFIG_FILE) as f:
        yaml_config = yaml.safe_load(f)
        value = yaml_config.get(key_name)
        if value is None:
            LOG.info(f"Can't get {key_name} because it's absent in {RP_CONFIG_FILE}")
        return value

def call_error(key_name):
    raise Exception(f"{key_name} should be defined in {RP_CONFIG_FILE} or "
                    f"by environment variable")

RP_APIKEY = environ.get('RP_APIKEY') or from_conf('RP_APIKEY') or call_error("RP_APIKEY")
RP_ENDPOINT = environ.get('RP_ENDPOINT') or from_conf('RP_ENDPOINT') or call_error("RP_ENDPOINT")
RP_PROJECT = environ.get('RP_PROJECT') or from_conf('RP_PROJECT') or call_error("RP_PROJECT")

RP_LOG_FILE = environ.get('RP_LOG_FILE') or from_conf('RP_LOG_FILE')
RP_LOGGING = environ.get('RP_LOGGING') or from_conf('RP_LOGGING') or logging.WARNING

logging.basicConfig(level=RP_LOGGING,
                    format='%(asctime)s %(levelname)s - %(filename)s:%(lineno)d (%(funcName)s) - %(message)s',
                    filename=RP_LOG_FILE,
                    filemode='w'
                    )

TIME_FORMAT = "%Y-%m-%d"

if __name__ == "__main__":
    LOG.info(f"RP_APIKEY: {RP_APIKEY}")
    LOG.info(f"RP_ENDPOINT: {RP_ENDPOINT}")
    LOG.info(f"RP_PROJECT: {RP_PROJECT}")