# TestRail bot

## Download repository
`git clone "https://gerrit.mcp.mirantis.com/mcp/osccore-qa-testing-tools"`

## Start docker-compose
`cd osccore-qa-testing-tools/testrail_bot`
`docker-compose up -d`


## Check logs
### Web
`docker-compose logs web`
### Nginx
`docker-compose logs nginx`
### Celery worker
`docker-compose logs worker`
### Redis
`docker-compose logs redis`
### PostgresSQL
`docker-compose logs db`


## Project structure
```
├── Dockerfile - docker file for django web and celery worker
├── README.md - documentation
├── control - Source code directory
│   ├── admin.py - register models for admin panel
│   ├── celery_tasks - celery tasks
│   │   ├── enums.py - simply enums for celery tasks
│   │   ├── filters.py - filters for testrail processing
│   │   ├── jenkins_pipeline.py - jenkins plot builder functionality
│   │   ├── tasks.py - main celery entry point
│   │   ├── test_rail_api.py - wrapper for testrail api
│   │   └── testrail_pipeline.py - testrail processor functionality
│   ├── forms.py - project's forms for web
│   ├── migrations - db migrations
│   ├── models.py - db models
│   ├── templates - html templates
│   │   ├── base.html - base html that should be extended
│   │   └── control
│   │       ├── create_run.html - html to create run
│   │       ├── help.html - html to help page
│   │       ├── index.html - html for main page
│   │       ├── jenkins_plot.html - jenkins plot html
│   │       ├── report.html - testrail report html
│   │       ├── reports.html - list of testrail reports
│   │       └── update_run.html - update existing run
│   ├── tests.py - place for tests
│   ├── urls.py - project urls
│   └── views.py - functions that handle api requests
├── docker-compose.yml - dev and prod docker configurations
├── js - projects js files
│   └── plot.js - jenkins plot js file
├── manage.py - command to control django app
├── media - media files
│   └── images - project images
│       └── control
│           ├── help_1.png - help page image
│           ├── help_2.png - help page image
│           └── help_3.png - help page image
├── nginx - nginx configuration
│   ├── Dockerfile - nginx docker file 
│   └── nginx.conf - nginx config file
├── requirements.txt - project requirements
├── start_webapp.sh - script to start web app
├── .env - configuration vars stored in file
└── testrail_bot - django staff
    ├── __init__.py
    ├── asgi.py
    ├── celery.py - celery config
    ├── settings.py - project settings
    ├── urls.py - project urls
```
