from __future__ import absolute_import, unicode_literals

import traceback

from celery import shared_task

from . import jenkins_pipeline, schedules_pipeline, testrail_pipeline


@shared_task
def process_run(bot_run_id, report_id, path, is_testplan):
    try:
        testrail_pipeline.process_test_run(
            bot_run_id, report_id, path, is_testplan
        )
    except BaseException as e:
        with open(path, "a") as f:
            print(f"Caught next exception: {e}")
            traceback.print_exc()
            f.write(
                "<b style='color:red;background-color:pink'>Task "
                "completed unsuccessfully</b>\n"
            )
            f.flush()


@shared_task
def update_plot_data():
    jenkins_pipeline.update_plot()


@shared_task
def get_test_passability_in_suite(diff_id: int, report_id: int):
    try:
        testrail_pipeline.get_test_passrate_in_suite(diff_id, report_id)
    except BaseException as e:
        print(f"Caught next exception: {e}")
        traceback.print_exc()
        from .. import models

        r = models.SuitePassRate.objects.get(pk=report_id)
        r.status = "Unexpected fail"
        r.finished = True
        r.save()


@shared_task
def check_today_testplan(*args, **kwargs):
    """
    Finds today testplan
    Creates TestRun with this id
    Creates Periodic task to analyze created TestRun

    :return:
    """
    schedules_pipeline.task_to_check_today_testplan()


@shared_task
def check_specific_testplan(testplan_id, *args, **kwargs):
    """
    Finds today testplan
    Creates TestRun with this id
    Creates Periodic task to analyze created TestRun

    :return:
    """
    schedules_pipeline.task_to_check_testplan(testplan_id)


@shared_task
def delete_old_2m_testruns(*args, **kwargs):
    """
    Finds today testplan
    Creates TestRun with this id
    Creates Periodic task to analyze created TestRun

    :return:
    """
    schedules_pipeline.task_to_delete_old_2m_testruns()


@shared_task
def delete_old_2m_reports(*args, **kwargs):
    """
    Finds today testplan
    Creates TestRun with this id
    Creates Periodic task to analyze created TestRun

    :return:
    """
    schedules_pipeline.task_to_delete_old_2m_reports()


@shared_task
def analize_testrail_reports(plan_name, *args, **kwargs):
    """
    Finds today testplan
    Creates TestRun with this id
    Creates Periodic task to analyze created TestRun
    :String plan_name
    :return:
    """
    schedules_pipeline.task_to_analize_testrail_reports(plan_name)
