import re
from pathlib import Path

import config


def get_full_filename(job_name, job_id):
    if not job_name or not job_id:
        return
    full_patch = config.LOGS_DIRECTORY + job_name + "/"
    patch_obj = Path(full_patch)
    if not patch_obj.exists():
        return

    file_obj = list(patch_obj.glob(f"{job_id}*.txt"))
    if len(file_obj) == 0:
        return
    return file_obj[0].as_posix()


def get_artifact_filename_id(file_patch):
    if not file_patch:
        return

    with open(file_patch) as file:
        for file_line in file:
            if "Starting building: oscore-artifatcts-collector" in file_line:
                artifact_id = file_line.split("#")[-1]
                return artifact_id.rstrip()


def get_artifact_link(artifact_file_patch):
    if not artifact_file_patch:
        return

    with open(artifact_file_patch) as file:
        for file_line in file:
            if """https://artifactory.mcp.mirantis.net/""" in file_line:
                artifact_link = re.findall(
                    "https:\/\/artifactory\.mcp\.mirantis\.net\/"
                    "artifactory\/oscore-local\/[a-zA-Z0-9-.]*\/[0-9-_]*\/",
                    file_line,
                )
                return artifact_link[0]


def update_all_jobs_results_with_artifacts(all_jobs_results):
    single_jobs_results = all_jobs_results["single_results"]
    for job in single_jobs_results:
        baseurl = all_jobs_results["single_results"][job]["baseurl"]
        job_id = baseurl.split("/")[-1]
        job_name = all_jobs_results["single_results"][job]["job_name"]

        file_patch = get_full_filename(job_name, job_id)

        artifact_filename_id = get_artifact_filename_id(file_patch)
        artifact_file_patch = get_full_filename(
            job_name="oscore-artifatcts-collector",
            job_id=artifact_filename_id,
        )
        artifact_link = get_artifact_link(artifact_file_patch)

        all_jobs_results["single_results"][job]["artifacts"] = artifact_link

    return all_jobs_results
