# Parcing testrail results

## Preparing the environment

1. Clone the repository `parcing_testrail_results`:
* Clone with SSH
    ~~~~
    git clone ssh://sturivnyi@gerrit.mcp.mirantis.com:29418/mcp/osccore-qa-testing-tools
    ~~~~
    
2. Install python 3.6 virtualenv:
    ~~~~
    apt install python3.6-venv
    ~~~~

3. Navigate to the `parcing_testrail_results/` folder:
   ~~~
   cd parcing_testrail_results/
   ~~~

4. Create virtualenv and activate it:
    ~~~~
    virtualenv --python=python3.6 .venv
    . .venv/bin/activate
    ~~~~

5. In the `parcing_testrail_results/` folder install requirements:
    ~~~~
    pip3 install -r requirements.txt
    ~~~~

6. Export environment variables:
   ~~~
   export TESTRAIL_USER="your_email@mirantis.com"
   export TESTRAIL_PASSWORD="testrail_super_secret_password"
   ~~~

## Preparing `config` file

1. Edit `config.py` file. Provide it with `TESTRAIL_TOKEN` and `TESTRAIL_COOKIES`

2. Getting `TESTRAIL_TOKEN` and `TESTRAIL_COOKIES`
* Use `Chromium` web browser
* Navigate to the any test-case in tetrail. For example, `https://mirantis.testrail.com/index.php?/tests/view/59746877`
* Open Chrome `DevTools` (press F12)
* In the `DevTools` window select `Network` tab
* In the browser click on the `History $ Context` tab
* In the `DevTools` window select `index.php?/tests/ajax_render_history` request
* In the `Headers` tab get `_token` and `cookie: tr_session` values
* Change `TESTRAIL_TOKEN` and `TESTRAIL_COOKIES` in the `config.py` file

## Running the script
 
1. Getting help:
   ~~~
   python html_testrail.py --help
   ~~~
   
2. Running the script:
   ~~~
   python html_testrail.py --run_id=63355
   ~~~
   
   Where:
   ```
    --run_id TEXT  Testrail run_id. For example, https://mirantis.testrail.com/index.php?/runs/view/63288 
   So run_id will be 63288
   ```
