from enum import IntEnum


class StatusEnum(IntEnum):
    passed = 1
    blocked = 2
    untested = 3
    retest = 4
    failed = 5
    skipped = 6
    in_progress = 7
    product_failed = 8
    test_failed = 9
    wont_fix = 10
    mixes_success = 11
    wont_test = 12

    def __eq__(self, other):
        if type(other) is str:
            other = int(other)
        return super().__eq__(other)

    def __str__(self):
        return str(self.value)


class TimeEnum(IntEnum):
    SECONDS = 1
    MINUTES = 60
    HOURS = 60 * MINUTES
    DAYS = 24 * HOURS
