import re


def filter_ip(data: str) -> str:
    ip_addr_regex = re.compile(r"\b(?:[0-9]{1,3}\.){3}[0-9]{1,3}\b")
    return re.sub(ip_addr_regex, "x.x.x.x", data)


def filter_uuid(data: str) -> str:
    uuid4hex = re.compile(
        r"[0-9a-f]{12}4[0-9a-f]{3}[89ab][0-9a-f]{15}\Z", re.I
    )
    return re.sub(uuid4hex, "xxxx", data)


def last_traceback_filter(data: str) -> str:
    if data.rfind("Traceback") < 0:
        return data
    return data[data.rfind("Traceback") :]
