Tempest Resources Parser
======================

This tool creating machine readable YAML file with all resources used in Tempest tests
The machine readable YAML file has the following format:

 """
    <test identifier>:
      status: PASSED|FAILED
      resources:
        <openstack-service name (nova|neutron|glance|keystone)>:
           <resource-name (port|server|security-group|router)>:
           <request-id (req-xxxx) >:
             name: <resource name (test-port-mytest|test-vm-)>
             id/uuid: <resource id>
             requst: <exact request>
            http:
               error: <if exists>
               status_code: <>
    """

How to use
----------

Update your env variables or add report and result file to artifacts dir
```
export REPORT_NAME='' \
export TEMPORARY_FILE_NAME='' \
export RESULT_FILE_NAME='' \
export TEMPEST_REPORT_XML=''
```

where REPORT_NAME is a tempest log file from your tempest run, TEMPORARY_FILE_NAME is any name of temporary file,
RESULT_FILE_NAME is name of the machine readable YAML file and TEMPEST_REPORT_XML is tempest report XML from your
tempest run.

Run report parser script to create a Yaml report for all test cases:

``python3 report_parser.py``

or to process requests from Setup/Tear Down Classes if the argument:

``python3 report_parser.py class``

or to create a Yaml report for one specific test case:

``python3 report_parser.py <test case name>``

 for example:

 ``python3 report_parser.py test_show_hypervisor_with_non_admin_user``


or to create a Yaml report for failed only test cases:

``python3 report_parser.py failed``


