## Install

In case of existed git repository
```shell
pip install .

```
or 
```shell
pip install "git+https://gerrit.mcp.mirantis.com/mcp/osccore-qa-testing-tools@master#egg=rp-reporter&subdirectory=rp_reporter"

```

## Use as a cli

It will proceed to all child job and to find defined xml reports (defined in code)

```shell
rp-reporter report-job https://mos-ci.infra.mirantis.net/job/deploy_job/58/

```

The next command should upload testresults for all jobs from the defined view. Tool takes into account only the last built builds

```shell
rp-reporter  report-view "https://mos-ci.infra.mirantis.net/view/MOSK%2024.3%20CI/"  
```

## Use as a module

```python
import rp_reporter
rp_reporter.upload_job("https://mos-ci.infra.mirantis.net/job/test-os-deploy-extended-core-ceph-local-non-dvr-ironic-mt-caracal-portgroups/6/", True)
```

## Configuration file
By default, it's located in `~/.reportportal_config`
You can change the default location by defining the `RP_CONFIG_FILE` environment variable 

### Example of config file
Config file is formatted as yaml 

```yaml
RP_APIKEY: <a lot of symbols>
RP_ENDPOINT: http://172.19.124.20/
RP_PROJECT: oscore
```
`RP_APIKEY` can be obtained in ReportPortal by url http://reportportal_url/ui/#userProfile/apiKeys 

All variables in configfile can be overwriten by defining the according environment variable