from datetime import date

from django import forms

from .models import (
    CronPeriodicTask,
    DiffOfSuitesPassRates,
    SuitePassRate,
    TestRailTestRun,
)


class TestRunForm(forms.ModelForm):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.fields["created_after"].widget = forms.SelectDateWidget(
            years=[date.today().year + i for i in range(-3, 5)]
        )
        self.fields["created_before"].widget = forms.SelectDateWidget(
            years=[date.today().year + i for i in range(-3, 5)]
        )

    class Meta:
        model = TestRailTestRun
        fields = "__all__"
        labels = {
            "project_name": "Name of the project",
            "plan_name": "Pattern for name of the Test Plan",
            "run_name": "Name of the run",
            "testrun_pattern": "Pattern for name of the Test Run",
            "run_id": "ID of the run/plan",
            "created_by_id": "ID of the user that created Test Plan",
            "filter_func": "Custom filter function",
            "ip_filter": "Mask all IP with x.x.x.x",
            "uuid_filter": "Mask all UUID with xxxx",
            "filter_last_traceback": "Use only traceback to "
            "compare comments",
            "created_after": "Search in period from",
            "created_before": "till",
            "caching_tests_enabled": "Don't check already checked results",
        }
        help_texts = {
            "filter_func": "Leave blank if not used",
            "created_before": "at 23:59:59",
            "created_after": "at 00:00:00",
        }


class DiffPassRatesForm(forms.ModelForm):
    class Meta:
        model = DiffOfSuitesPassRates
        fields = ["limit", "test_keyword"]
        labels = {
            "test_keyword": "Pattern to search by tests",
            "limit": "Count of tests to define the passrate. Don't recommend "
            "to use a number greater that 10",
        }


class SuitePassRateForm(forms.ModelForm):
    class Meta:
        model = SuitePassRate
        fields = ["suite_id"]
        labels = {"suite_id": "Suite ID"}


class PeriodicTaskForm(forms.ModelForm):
    class Meta:
        model = CronPeriodicTask
        fields = [
            "id",
            "enabled",
            "name",
            "cron",
            "task_name",
            "testplan_id_arg",
        ]
