"""
-------------
Manage files
-------------
"""

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
import os
import time

import config

logging.basicConfig(
    format="[%(asctime)s][%(name)s][%(levelname)s] %(message)s",
    datefmt="%d-%m-%Y %H:%M:%S",
    handlers=[
        logging.FileHandler(
            "{}{}".format(config.LOGGIGNG_FOLDER, config.LOG_FILENAME)
        ),
        logging.StreamHandler(),
    ],
    level=logging.INFO,
)
logger = logging.getLogger("delete_old_files")


def delete_old_files(days, path):
    logger.info("Removing files older than {} days".format(days))
    time_secs = time.time() - (days * 86400)
    for root, dirs, files in os.walk(path, topdown=False):
        for file in files:
            full_path = os.path.join(root, file)
            stat = os.stat(full_path)
            if stat.st_mtime <= time_secs:
                logger.info("removing: {}".format(full_path))
                os.remove(full_path)
