CLI helper tool
======================

This CLI helper tool gathers all log lines related to resource | req-id from particular folder with logs.
All related resources and their IDs used in Tempest tests are stored in machine-readable YAML file with the following 
format:

```
<test identifier>:
  status: PASSED|FAILED
  resources:
    <openstack-service name (nova|neutron|glance|keystone)>:
       <resource-name (port|server|security-group|router)>:
       <request-id (req-xxxx) >:
         name: <resource name (test-port-mytest|test-vm-)>
         id/uuid: <resource id>
         request: <exact request>
        http:
           error: <if exists>
           status_code: <>
```

This machine-readable YAML file can be generated using _report_parcer_ tool:
`https://gerrit.mcp.mirantis.com/plugins/gitiles/mcp/osccore-qa-testing-tools/+/refs/heads/master/tempest_tests_resources`


## Preparing the environment

1. Clone the repository `log_helper`:
* Clone with SSH
    ~~~~
    git clone ssh://gerrit.mcp.mirantis.com:29418/mcp/osccore-qa-testing-tools
    ~~~~
  
2. Navigate to the `log_helper/` folder:
   ~~~
   cd log_helper/
   ~~~

3. Edit 'config.py' file and provide it with required values:

   * `RESULTS_DIR`, `LOG_DIR` and `TEMPEST_REPORT_YAML`


4. In the `log_helper/` folder install log_helper tool:
    ~~~~
    python3 -m pip install -e .
    ~~~~


How to use
----------

- Extract/save all openstack logs to folder (ex. pod-logs)

- Generate a tempest report using the report_parcer tool with the format as descideb above

- Run log_helper tool using two options:

1. with no parameters (LOG_DIR and TEMPEST_REPORT_YAML file as config parameters):

``log_helper.py``

2. with resource-id and log-level (optional) as input parameters (LOG_DIR as config parameter):

``log_helper.py <resource-id>``

    or

``log_helper.py <resource-id> <log-level>``

Example:

``log_helper.py req-aabbb391-ff60-4893-9b20-60f6a29749c9 ERROR``
