from django.urls import path

from . import views

urlpatterns = [
    path("", views.redirect_to_index, name="redirect"),
    path("runs/", views.create_run, name="create_run"),
    path("runs/<int:run_id>/", views.single_run, name="single_run"),
    path("runs/<int:run_id>/submit/", views.submit_run, name="submit_run"),
    path("runs/<int:run_id>/delete/", views.delete_run, name="delete_run"),
    path("reports/", views.list_reports, name="list_reports"),
    path(
        "reports/<int:report_id>/", views.single_report, name="single_report"
    ),
    path(
        "reports/<int:report_id>/delete",
        views.delete_report,
        name="delete_report",
    ),
    path(
        "reports/<int:report_id>/update/<int:result_id>/<int:action_needed>",
        views.update_test_result,
        name="update_test_result",
    ),
    path("index/", views.index, name="index"),
    path("help/", views.show_help, name="help"),
    path(
        "update_jenkins_plot", views.update_jenkins_plot, name="update_jenkins"
    ),
    path("jenkins_plot", views.jenkins_plot, name="jenkins_plot"),
    path("schedulers/", views.schedulers, name="schedulers"),
    path("scheduler/new/", views.scheduler, name="create_scheduler"),
    path("scheduler/<int:pk>/", views.scheduler, name="scheduler"),
    path(
        "scheduler/<int:pk>/save", views.save_scheduler, name="save_scheduler"
    ),
    path(
        "scheduler/<int:pk>/delete/",
        views.delete_scheduler,
        name="delete_scheduler",
    ),
    path("compare_suites/new/", views.compare_suites, name="compare_suites"),
    path(
        "compare_suites/",
        views.list_of_comparing_reports,
        name="list_of_comparing_reports",
    ),
    path("compare_suites/submit/", views.submit_suites, name="submit_suites"),
    path(
        "compare_suites/<int:report_id>/",
        views.report_comparing_suites,
        name="report_comparing_suites",
    ),
]
