#!/bin/bash -xe

if [ ! -f /etc/tempest/tempest.conf ]
then
    echo "Please put your tempest.conf file to /etc/tempest/"
    exit 1
fi

if [ -n "${REPORT_SUFFIX}" ]
then
    report="report_${REPORT_SUFFIX}"
else
    report='report_'`date +%F_%H-%M`
fi

log=$LOG_DIR/${report}.log

cat /etc/tempest/tempest.conf | tee -a ${log}

cd $LOG_DIR
rm -rf env

tempest init env | tee -a $log
cd env

cp /var/lib/tempest/skiplists/*.list $LOG_DIR/env

tempest run $ARGS | tee -a ${log}

if [[ "$ARGS" =~ '-r ' || "$ARGS" =~ '--regex' || "$ARGS" =~ '-s' || "$ARGS" =~ '--smoke' || "$ARGS" =~ '--blacklist-file' || "$ARGS" =~ '-w' || "$ARGS" == '' ]]; then
    stestr last --subunit | subunit2junitxml > $LOG_DIR/$report.xml || true
fi
