import pytest
import random
import string


@pytest.fixture(scope='session')
def policy_user(openstack_client_manager):
    letters = string.ascii_lowercase
    user_name = "si_user_" + (
        ''.join(random.choice(letters) for i in range(5)))
    password = (''.join(random.choice(letters) for i in range(5)))
    openstack_client_manager.user.create(["--domain", "default",
                                          "--project", "admin",
                                          "--password", password,
                                          user_name])
    openstack_client_manager.role.add(["--user", user_name,
                                       "--project", "admin", "member"])
    yield user_name, password

    openstack_client_manager.user.delete([user_name])
