import exec_helpers
import yaml
import json
import pytest

from si_tests import settings
from si_tests import logger
from si_tests.managers.tungstenfafric_manager import TFManager
import si_tests.utils.templates as utils
from si_tests.utils import waiters

LOG = logger.logger


@pytest.mark.parametrize("_", [f"CLUSTER_NAME={settings.TARGET_CLUSTER}"])
@pytest.mark.usefixtures('introspect_no_PRODX_51933_after_lcm')
def test_tungsten_pytest(kaas_manager, _):
    result_pod_path = "/tungsten-pytest/data"
    result_pod_file = "results.xml"
    test_pod_name = "tf-test-tungsten-pytest"
    test_pod_ns = "tf"
    test_report_name = "tf_report"
    cluster_name = settings.TARGET_CLUSTER
    target_namespace = kaas_manager.get_namespace(settings.TARGET_NAMESPACE)
    target_cluster = target_namespace.get_cluster(cluster_name)
    kubectl_client = target_cluster.k8sclient

    # Write child kubeconfig
    child_kubeconfig_name, child_kubeconfig = target_cluster.get_kubeconfig_from_secret()
    with open('child_conf', 'w') as f:
        f.write(child_kubeconfig)
    tf_manager = TFManager(kubeconfig='child_conf')

    # Run tf-tests and wait for completion
    test_pod_phase = tf_manager.run_pytest()

    logs = kubectl_client.pods.api.read_namespaced_pod_log(
        name=test_pod_name, namespace=test_pod_ns)
    LOG.info(logs)

    # Run result pod for extracting results.xml from PV
    options = {
        'RESULT_POD_NAME': test_pod_name+"-result",
        'RESULT_POD_NS': test_pod_ns,
        'RESULT_POD_PV': "tf-test-data-volume",
        'RESULT_POD_PVC': "tf-test-tungsten-pytest",
        'RESULT_POD_MOUNT_PATH': result_pod_path
    }
    templates = utils.render_template(settings.TUNGSTEN_RESULT_POD_YAML, options)
    LOG.debug(templates)
    json_body = json.dumps(yaml.load(templates, Loader=yaml.SafeLoader))
    result_pod = kubectl_client.pods.create(
        name=test_pod_name+"-result",
        namespace=test_pod_ns,
        body=json.loads(json_body))
    result_pod.wait_phase('Running')
    result_pod.wait_test(filepath=result_pod_path+'/'+result_pod_file, timeout=60)
    result_pod.cp_from_pod(source_dir=result_pod_path, source_file=result_pod_file)
    exec_helpers.Subprocess().check_call(
        f"test -f artifacts/results.xml && mv artifacts/results.xml {settings.ARTIFACTS_DIR}/{test_report_name}.xml")
    result_pod.delete()
    LOG.info("Disabling tungsten pytest in tf-operator")
    tf_manager.enable_tf_test(state=False)
    LOG.info("Waiting for pod deleted by tf-operator")
    waiters.wait(lambda: not kubectl_client.pods.present(test_pod_name, test_pod_ns), timeout=120, interval=10)
    # Finally check test pod phase
    assert test_pod_phase == "Succeeded", f"Test pod phase is {test_pod_phase}. Check test results."
