#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1TFControl(base.BaseModel):
    pass


class V1TFControlList(base.BaseModelList):
    pass


class TFControl(base.K8sNamespacedResource):
    resource_type = 'tfcontrol'
    model = V1TFControl


class TFControlManager(base.K8sBaseManager):
    model = V1TFControlList
    resource_class = TFControl
    resource_group = 'control.tf.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'tfcontrols'


class V2TFControl(base.BaseModel):
    pass


class V2TFControlList(base.BaseModelList):
    pass


class TFControlV2(base.K8sNamespacedResource):
    resource_type = 'tfcontrol'
    model = V2TFControl


class TFControlManagerV2(base.K8sBaseManager):
    model = V2TFControlList
    resource_class = TFControlV2
    resource_group = 'tf.mirantis.com'
    resource_version = 'v2'
    resource_plural = 'tfcontrols'
