#    Copyright 2017 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations


from si_tests.clients.k8s.base import K8sNamespacedResource
from si_tests.clients.k8s.base import K8sBaseManager


class K8sReplicaSet(K8sNamespacedResource):
    resource_type = 'replicaset'

    def _read(self, **kwargs):
        return self._manager.api.read_namespaced_replica_set(
            self.name, self.namespace, **kwargs)

    def _create(self, body, **kwargs):
        return self._manager.api.create_namespaced_replica_set(
            self.namespace, body, **kwargs)

    def _patch(self, body, **kwargs):
        return self._manager.api.patch_namespaced_replica_set(
            self.name, self.namespace, body, **kwargs)

    def _replace(self, body, **kwargs):
        return self._manager.api.replace_namespaced_replica_set(
            self.name, self.namespace, body, **kwargs)

    def _delete(self, **kwargs):
        self._manager.api.delete_namespaced_replica_set(
            self.name, self.namespace, **kwargs)

    @property
    def data(self):
        """Returns dict of k8s object

        Data contains keys like api_version, kind, metadata,
        spec, status or items
        """
        return self.read().to_dict()

    @property
    def desired_replicas(self):
        return self.read().spec.replicas

    @property
    def ready_replicas(self):
        """
        Returns value of ready_replicas field
        """
        status = self.data.get('status') or {}
        return status.get('ready_replicas', 0)


class K8sReplicaSetManager(K8sBaseManager):
    resource_class = K8sReplicaSet

    @property
    def api(self):
        return self._cluster.api_apps

    def _list(self, namespace, **kwargs):
        return self.api.list_namespaced_replica_set(namespace, **kwargs)

    def _list_all(self, **kwargs):
        return self.api.list_replica_set_for_all_namespaces(**kwargs)
