from si_tests import settings
from si_tests import logger

LOG = logger.logger


def test_add_service_to_clusterdeployment(kcm_manager, show_step):
    """Add services into existing ClusterDeployment object, using template with the defined list of services

    Scenario:
        1. Access target cluster and check that cluster is Ready and accessible
        2. Read 'services' from the specified template file
        3. Patch cluster deployment to apply service templates
        4. Wait for the service's Sveltos Helm release readiness
        5. Wait for cluster deployment became ready
        6. Check expected pods
    """
    show_step(1)
    ns = kcm_manager.get_namespace(settings.TARGET_NAMESPACE)
    cld = ns.get_cluster_deployment(settings.TARGET_CLD)
    cld.check.check_actual_expected_pods()
    # Limit readiness check since we should have already deployed working cluster
    cld.check.check_cluster_readiness(timeout=600)
    LOG.info(f"Clusterdeployment {cld.namespace}/{cld.name} checked and ready.")

    show_step(2)

    assert settings.CUSTOM_CLUSTERDEPLOYMENT_SERVICES_PATH

    cld_body = kcm_manager.get_template_from_file(settings.CUSTOM_CLUSTERDEPLOYMENT_SERVICES_PATH)
    cld_services = cld_body.get("spec", {}).get("serviceSpec", {}).get('services')

    assert cld_services

    show_step(3)
    LOG.info(f"Applying service templates to cluster deployment {cld.namespace}/{cld.name}")
    cld.apply_service_templates(svc_list=cld_services)

    show_step(4)
    for cld_service in cld_services:
        service_name = cld_service['name']
        service_namespace = cld_service['namespace']
        cld.check.wait_service_condition(service_name, service_namespace)

    show_step(5)
    cld.check.check_cluster_readiness(timeout=1800)

    show_step(6)
    cld.check.check_actual_expected_pods()
