from si_tests import settings
from si_tests import logger

LOG = logger.logger


def test_create_region(kcm_manager, show_step):
    """Create a region object and check that region entities created in target cluster

    Scenario:
        1. Gather evnironment config
        2. Gather regional clusterdeployment
        3. Delete region object and check clusterdeployment state
    """
    show_step(1)
    region_name = settings.KSI_KCM_REGION_NAME
    region = kcm_manager.api.k0rdent_regions.get(name=region_name)
    assert region_name, "Variable KSI_KCM_REGION_NAME can not be empty"

    show_step(2)
    # TODO(va4st) for now it's not possible to use different namespace than system due ksi limitations
    system_ns = kcm_manager.get_namespace(settings.KCM_NAMESPACE)
    cld = system_ns.get_cluster_deployment(region.clustername)

    show_step(3)
    kcm_manager.delete_region_by_name_and_wait(name=region.name)
    cld._refresh_expected_objects()
    cld.check.check_actual_expected_pods()
