from si_tests import settings
from si_tests import logger

LOG = logger.logger


def test_create_region(kcm_manager, show_step):
    """Create a region object and check that region entities created in target cluster

    Scenario:
        1. Gather environment config
        2. Access target cluster and check that cluster is Ready and accessible
        3. Create region object
        4. Wait for region to become Ready
        5. Check expected pods and cluster state
    """
    show_step(1)
    # TODO(va4st) for now it's not possible to use different namespace than system due ksi limitations
    ns = kcm_manager.get_namespace(settings.KCM_NAMESPACE)
    cld = ns.get_cluster_deployment(settings.TARGET_CLD)
    region_name = settings.KSI_KCM_REGION_NAME
    assert region_name, "Variable KSI_KCM_REGION_NAME can not be empty"

    show_step(2)
    cld.check.check_actual_expected_pods()
    # Limit readiness check since we should have already deployed working cluster
    cld.check.check_cluster_readiness(timeout=600)
    LOG.info(f"Clusterdeployment {cld.namespace}/{cld.name} checked and ready.")
    # TODO(va4st) assert kubeconfig of the desied cluster is present in system namespace when in ksi will be possible
    # TODO(va4st) use different namespace than system

    show_step(3)
    kubeconfig_name = f"{cld.name}-kubeconfig"
    region = kcm_manager.create_kcm_region(kubeconfig_name=kubeconfig_name)

    show_step(4)
    region.wait_for_readiness()

    show_step(5)
    cld.check.check_k8s_nodes()
    cld.check.check_k8s_pods()
    cld._refresh_expected_objects()
    cld.check.check_actual_expected_pods()
