from si_tests import settings
from si_tests import logger

LOG = logger.logger


def test_create_multiclusterservice(kcm_manager, show_step):
    """Create MultiClusterServices and check it's status

    Scenario:
        1. Read MultiClusterService from the template file CUSTOM_MULTI_CLUSTER_SERVICES_PATH
        2. Create MultiClusterService object
        3. Check the MultiClusterService status.conditions readiness
    """

    show_step(1)
    assert settings.CUSTOM_MULTI_CLUSTER_SERVICES_PATH, (
        "Please specify path to the MultiClusterService in variable CUSTOM_MULTI_CLUSTER_SERVICES_PATH")

    mcs_body = kcm_manager.get_template_from_file(settings.CUSTOM_MULTI_CLUSTER_SERVICES_PATH)
    mcs_name = mcs_body.get("metadata", {}).get("name")
    mcs_services = mcs_body.get("spec", {}).get("serviceSpec", {}).get('services')

    assert mcs_name, (
        f"MultiClusterService '{settings.CUSTOM_MULTI_CLUSTER_SERVICES_PATH}' "
        f"doesn't contain metadata.name")
    assert mcs_services, (
        f"MultiClusterService '{settings.CUSTOM_MULTI_CLUSTER_SERVICES_PATH}' "
        f"doesn't contain any service in spec.serviceSpec.services")

    show_step(2)
    LOG.info(f"Applying MultiClusterTemplate '{mcs_name}'")
    mcs = kcm_manager.create_multi_cluster_service(mcs_name, mcs_body)

    # Check the conditions of the MCS object
    # kcm_manager.wait_mcs_readiness(mcs.name)
    mcs.wait_for_readiness()
