# MultiClusterServices test module

## Overview
This directory contains tests related to MultiClusterServices management (CRUD).

## Test Suite

- [Create MultiClusterServices](#test_create_multiclusterservicespy)

## Pre-requisites

- Working k0rdent kcm installation required to execute any of those tests

## Common variables for each test and customization of runs

| ENV Variable                         | Type     | Description                                                                                                                                                                              | Defaults                              |
|--------------------------------------|----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------|
| `KUBECONFIG`                         | `<str>`  | Path to KCM cluster KUBECONFIG                                                                                                                                                           |                                       |

## Existing tests and requirements

### test_create_multiclusterservices.py
This test creates a MultiClusterService and checks its status.conditions. It can create MultiClusterService for KCM or Child clusters depending on the provided template file.

#### Variables that MUST be filled before run and have no default value
| ENV Variable                         | Type     | Description                                           |
|--------------------------------------|----------|-------------------------------------------------------|
| `CUSTOM_MULTI_CLUSTER_SERVICES_PATH` | `<str>`  | (**mandatory**) Path to the MultiClusterServices YAML file with service definitions. Examples can be found in the directory 'si_tests/templates/deploy-objects/multiclusterservices/'    | Not set                               |

#### Optional variables to customize the deployment
There are no optional variables specific to this test.

## Additional information

This test deploys MultiClusterService objects which can be used to manage services across multiple clusters. The service definitions should be provided in a YAML format that follows the MultiClusterService specification.