import pytest

from si_tests import logger
from si_tests import settings

LOG = logger.logger


@pytest.mark.usefixtures('log_step_time')
@pytest.mark.usefixtures('log_method_time')
def test_install_kof_mothership_istio(kcm_bootstrap_manager, show_step):
    """Install and configure kof into k0rdent management cluster with Istio underlay

    Scenario:
        1. Create kof namespace and generate name prefix
        2. Install kof istio
        3. Install kof operators and wait for readiness
        4. Prepare DNS config and mothership values
        5. Install kof mothership
    """
    show_step(1)
    kcm_manager = kcm_bootstrap_manager.check.kcm_mgr
    kof_ns = kcm_manager.get_or_create_namespace(settings.KSI_KOF_NAMESPACE)
    istio_labels = {'istio-injection': 'enabled'}
    kof_ns.add_labels(labels=istio_labels)

    show_step(2)
    kcm_manager.kof.install_kof_istio()
    kcm_bootstrap_manager.check.wait_kof_istio_ready()
    kcm_manager.refresh_expected_objects()
    kcm_bootstrap_manager.check.check_k8s_pods()
    kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(3)
    kcm_manager.kof.install_kof_operators()
    kcm_bootstrap_manager.check.wait_kof_op_ready()
    kcm_manager.refresh_expected_objects()
    kcm_bootstrap_manager.check.check_k8s_pods()
    kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(4)
    values = kcm_manager.kof.get_mothership_values()

    show_step(5)
    kcm_manager.kof.install_kof_mothership(values=values)
    kcm_bootstrap_manager.check.wait_kof_mothership_ready()
    kcm_manager.refresh_expected_objects()
    kcm_bootstrap_manager.check.check_k8s_pods()
    kcm_bootstrap_manager.check.check_actual_expected_pods()
