# KOF test module

## Overview
This directory contains different tests related to kof installation into k0rdent kcm

## Pre-requisites

- Working k0rdent (kcm) installation

## Detailed description of checks inside kof install test (test_install_kof.py)

The test install kof charts chain. Checks for that include:
- Wait for helmcharts to be installed
- Verify that after installation of the charts expected resources appeared
- Expected pods presence and statuses check for suitable kof versions

### Enterprise installation

Does not supported yet.

### Airgapped installation

Does not supported yet.

### KOF Underlays

There few different tests with different steps inside depends on underlay chosen. Each test can be run once for one environment.
Full documentation about options related to DNS, Istio and manual configuration can be viewed in [official docs](https://docs.k0rdent-enterprise.io/latest/admin/kof/kof-install/#prerequisites)

#### Istio (test_install_kof_mothership_istio.py)

Test will act as the istio-related [documentation](https://docs.k0rdent.io/latest/admin/kof/kof-install/#istio)

Will install and check charts installation:
1. kof-istio
2. kof-operators
3. kof-mothership

#### AWS Auto Dns (test_install_kof_mothership_aws.py)

Test will act as the aws-related [documentation](https://docs.k0rdent.io/latest/admin/kof/kof-install/#aws)

Will install and check charts installation:
1. kof-operators
2. kof-mothership
3. kof-regional
4. kof-child

#### Manual (test_install_kof_mothership_manual.py)

Test will act as the manual-related [documentation](https://docs.k0rdent.io/latest/admin/kof/kof-verification/#manual-dns-config)

Will install and check charts installation:
1. kof-operators
2. kof-mothership
3. kof-regional
4. kof-child

### Execution

```bash
py.test $(KSI_HOME)/si_tests/kof/test_install_kof_mothership.py
```

### Source parameter

The main parameter which represents the source of kcm installation.

| ENV Variable     | Type    | Description                                                                         | Defaults     |
|------------------|---------|-------------------------------------------------------------------------------------|--------------|
| `KSI_KOF_SOURCE` | `<str>` | KOF source of chart to be installed from. Defaults to value of KCM_SOURCE parameter | `KCM_SOURCE` |

This variable can have the values: `opensource` `enterprise` or `custom-enterprise`

#### KCM_SOURCE='enterprise'

In that case ksi will use enterprise regestry with default values existing inside chart.
Repo which will be used for install: "oci://registry.mirantis.com/k0rdent-enterprise".

helm install command inside test will be looks like
```bash
helm install kof oci://registry.mirantis.com/k0rdent-enterprise/kof --version 1.1.0 --kubeconfig working/kubeconfig --namespace kcm-system --timeout 5m --create-namespace --wait
```

#### KCM_SOURCE='custom-enterprise'

It's not expected to have custom deployments for oss, so only enterprise supported. This way require custom registry and other infrastructure 
that can be also used in Airgapped environments.
It that case it's needed to set additional mandatory variables to configure release.

| ENV Variable              | Type    | Description                                                                              | Example               |
|---------------------------|---------|------------------------------------------------------------------------------------------|-----------------------|
| `KSI_KOF_CUSTOM_REGISTRY` | `<str>` | Repo with charts, images, etc without protocol. Defaults to value of KCM_CUSTOM_REGISTRY | `KCM_CUSTOM_REGISTRY` |

### Optional parameters

| ENV Variable                        | Type     | Description                                                                                                 | Defaults |
|-------------------------------------|----------|-------------------------------------------------------------------------------------------------------------|----------|
| `KSI_HELM_INSECURE`                 | `<bool>` | Add or not --insecure-skip-tls-verify flag to the helm comands                                              | `False`  |
| `KSI_CUSTOM_REGISTRY_CERT_PATH` | `<str>`  | Path to the Root CA for registry. Mutually exclusive with KSI_CUSTOM_REGISTRY_CERT_TEXT | `False`  |
| `KSI_CUSTOM_REGISTRY_CERT_TEXT` | `<str>`  | Plain-text Root CA for registry. Mutually exclusive with KSI_CUSTOM_REGISTRY_CERT_PATH | `False`  |

example helm install command inside test will be looks like

```bash
helm install kcm oci://<KSI_KOF_CUSTOM_REGISTRY>/charts/kof-istio --version 1.1.0 --kubeconfig working/kubeconfig --namespace kcm-system --timeout 5m --create-namespace --wait
```
KSI_KOF_CUSTOM_REGISTRY will be passed to helm via temporal values file:
```yaml
{
            'global': {
                'registry': KSI_KOF_CUSTOM_REGISTRY,
                'imageRegistry': KSI_KOF_CUSTOM_REGISTRY,
                'image': {
                    'registry': KSI_KOF_CUSTOM_REGISTRY,
                },
                'hub': KSI_KOF_CUSTOM_REGISTRY/istio"
            },
            'grafana-operator': {
                'image': {
                    'repository': KSI_KOF_CUSTOM_REGISTRY/grafana/grafana-operator"
                }
            },
            'external-dns': {
                'image': {
                    'repository': KSI_KOF_CUSTOM_REGISTRY/external-dns/external-dns"
                }
            },
            'jaeger-operator': {
                'image': {
                    'repository': KSI_KOF_CUSTOM_REGISTRY/jaegertracing/jaeger-operator"
                }
            },
            'opencost': {
                'opencost': {
                    'exporter': {
                        'image': {
                            'registry': KSI_KOF_CUSTOM_REGISTRY
                        }
                    },
                    'ui': {
                        'image': {
                            'registry': KSI_KOF_CUSTOM_REGISTRY
                        }
                    }
                }
            },
            'opentelemetry-operator': {
                'manager': {
                    'image': {
                        'repository': KSI_KOF_CUSTOM_REGISTRY/opentelemetry-operator/opentelemetry-operator"
                    },
                    'collectorImage': {
                        'repository': KSI_KOF_CUSTOM_REGISTRY/otel/opentelemetry-collector-contrib"
                    }
                },
                'kubeRBACProxy': {
                    'image': {
                        'repository': KSI_KOF_CUSTOM_REGISTRY/brancz/kube-rbac-proxy"
                    }
                }
            },
            'kcm': {
                'installTemplates': 'true',
                'kof': {
                    'operator': {
                        'image': {
                            'repository': 'kof/kof-operator-controller'
                        }
                    }
                }
            }
        }
```

kof-mothership values will be generated by default as in [documented](https://docs.k0rdent-enterprise.io/latest/admin/kof/kof-install/#management-cluster)
It will always have these parameters.
```yaml
{
    'kcm': {
        'installTemplates': true
    }
}
```

### Expected pods check

After installation of each chart expected pods check will be executed. 

### Variables that MUST be filled before run and have no default value

| ENV Variable            | Type    | Description             | Example                                       |
|-------------------------|---------|-------------------------|-----------------------------------------------|
| `KUBECONFIG`            | `<str>` | Path to KUBECONFIG file | `./kubeconfig`                                |
| `KSI_KOF_CHART_VERSION` | `<str>` | Version of KOF charts   | `1.0.0` |

### Optional variables to customise the deployment

| ENV Variable            | Type    | Description               | Defaults         |
|-------------------------|---------|---------------------------|------------------|
| `KSI_KOF_NAMESPACE`     | `<str>` | Namespace to install kof  | `kof`            |
| `KSI_KOF_OP_CHART_NAME` | `<str>` | kof operators chart name  | `kof-operators`  |
| `KSI_KOF_MS_CHART_NAME` | `<str>` | kof mothership chart name | `kof-mothership` |
| `KSI_KOF_RE_CHART_NAME` | `<str>` | kof regional chart name   | `kof-regional`   |
| `KSI_KOF_CH_CHART_NAME` | `<str>` | kof child chart name      | `kof-child`      |
| `KSI_KOF_IS_CHART_NAME` | `<str>` | kof istio chart name      | `kof-istio`      |


## Cleanup (test_cleanup_kof.py)

Full clean up the kof stack including namespace.

### Execution

```bash
py.test $(KSI_HOME)/si_tests/bootstrap/test_cleanup_kof.py
```
